<?php

namespace app\db\admin;

use app\model\M_software_upgrade_log;

class D_software_upgrade_log
{
    /**
     * 信息格式化
     */
    protected function detailed($Result)
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = $Result['updateTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']):"";
        }
        // 是否显示
        if (isset($Result['isShow'])) {
            $isShowMap=array();
            $isShowMap["1"]="显示";
            $isShowMap["0"]="不显示";
            $Result['isShowFormat'] = isset($isShowMap[$Result['isShow']])?$isShowMap[$Result['isShow']]:"";
        }
        // 包大小
        if (isset($Result['packageSize'])) {
            $Result['packageSizeFormat'] = $Result['packageSize'] >0?app("ltcmsFormat")->byte($Result['packageSize']):"";
        }
        // 项目
        if (isset($Result['project'])) {
            $projectMap=array();
            $projectMap["lt_cms"]="龙腾cms";
            $projectMap["lt_official_site"]="龙腾官网";
            $Result['projectFormat'] = isset($projectMap[$Result['project']])?$projectMap[$Result['project']]:"";
        }
        // 结果
        if (isset($Result['result'])) {
            $resultMap=array();
            $resultMap["0"]="未处理";
            $resultMap["1"]="成功";
            $resultMap["2"]="失败";
            $Result['resultFormat'] = isset($resultMap[$Result['result']])?$resultMap[$Result['result']]:"";
        }
        // 阶段
        if (isset($Result['stage'])) {
            $stageMap=array();
            $stageMap["base"]="设计阶段(base)";
            $stageMap["alpha"]="内侧版本(alpha)";
            $stageMap["beta"]="公测版本(beta)";
            $stageMap["rc"]="即将发布版本(rc)";
            $stageMap["release"]="正式版本(release)";
            $Result['stageFormat'] = isset($stageMap[$Result['stage']])?$stageMap[$Result['stage']]:"";
        }
        // 返回结果
        return $Result;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'size' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["size"] = "20";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            try {
                $result = Db()->name(app("cmsTable")::softwareUpgradeLog())->field($dataObj->request->field)->order("id", "desc")->where($condition)->paginate(array("pageSize"=>$dataObj->request->size));
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        $result["data"][$key] = $this->detailed($val);
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'verify' => '',
                'lock' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $lock=$dataObj->request->lock?true:false;
                $result = Db()->name(app("cmsTable")::softwareUpgradeLog())->field($dataObj->request->field)->lock($lock)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    $final_arr["result"] =$dataObj->request->format?$this->detailed($result):$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'project' => 'require',
                'stage' => 'require',
                'version' => 'require',
                'date' => 'require',
                'packageUrl' => 'require',
                'result' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_software_upgrade_log::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["version_complete"]=$data["version"]."_".$data["date"]."_".$data["stage"];
                if(isset($data["packageUrl"]) && $data["packageUrl"]){
                    $data["packageSize"]=fileInfo($data["packageUrl"], "content-length",0);
                }
                if(isset($data["version"]) && $data["version"]){
                    $data["version_nums"]=str_replace(".","",$data["version"]);
                }
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::softwareUpgradeLog())->data($data)->insert();
                if($result["insert_id"] >0){
                    $return = array();
                    $return["id"] = $result["insert_id"];
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] =$return;
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'result' => '',
                'oldFile' => '',
                'updateFile' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoData=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->data->infoData["id"]
            );
            unset($dataObj->request->id);
            $fields=M_software_upgrade_log::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if ($data) {
                $data["updateTime"] = app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::softwareUpgradeLog())->where($condition)->data($data)->update();
                    if($result["affected_rows"] >= "0"){
                        $return = array();
                        $return["id"] = $dataObj->data->infoData["id"];
                        $return["affected_rows"] = $result["affected_rows"];
                        $final_arr["result"] =$return;
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::softwareUpgradeLog())->where($condition)->delete();
                $return = array();
                $return["id"] = $ids;
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}