<?php

namespace app\db\admin;

class D_singlePageGroup
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format)
    {
        // 返回结果
        return $Result;
    }
    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'format' => '',
                'verify' => '',
            );
            $dataDefault["verify"] = 1;
            $dataDefault["format"] = 1;
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", trim($dataObj->request->id)
            );
            try {
                $result = Db()->name(app("cmsTable")::single_page_group())->where($condition)->find();
                if ($dataObj->request->format) {
                    $result = $this->detailed($result, $dataObj->request->format);
                }
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }


                if ($final_arr["error_no"] == 0 && $result) {
                    $final_arr["result"] = $result;
                }

            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                "id" => "require",
                "name" => "require",
            );

            $dataDefault = array(
            );

            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }


        //数据库操作============
        if ($final_arr["error_no"] == 0) {
            try {
                $data = array();
                $allowUpdates = ["id",   "name"]; //允许更新的字段
                foreach ($dataObj->request as $key => $value) {
                    if (in_array($key, $allowUpdates)  && $value !== null) {
                        $data[$key] = trim($value);
                    }
                }
                $result = Db()->name(app("cmsTable")::single_page_group())->insert($data);
                $return = array();
                $return["id"] = $result["insert_id"];
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                "name" => "",
                "verify" => "",
            );

            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->verify) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "id" => trim($dataObj->request->id),
                    "verify" => 1,
                );
                $checkResult = $this->info($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }

        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", trim($dataObj->request->id)
            );

            $data = array();
            $allowUpdates = [ "name"]; //允许更新的字段
            foreach ($dataObj->request as $key => $value) {
                if (in_array($key, $allowUpdates) && $value !== null) {
                    $data[$key] = trim($value);
                }
            }
            if ($data) {
                try {
                    $result = Db()->name(app("cmsTable")::single_page_group())->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = trim($dataObj->request->id);
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }


    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //判断 id是否为数组,如果是数组,返回id数组,如果不是数组,返回单成员数组
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::single_page_group())->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'order' => '',
                'type' => 'number',
                'keyword' => '',
                'format' => '',
                'field' => '',
            );
            $dataDefault = array(
                'order' => '0',
                'format' => '1',
            );
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();

            if ($dataObj->request->keyword){
                switch ($dataObj->request->type){
                    case 1:
                        $condition[] = array(
                            "title", "like", "%{$dataObj->request->keyword}%"
                        );
                        break;
                }
            }


            //处理 排序  设置默认0
            $sortColumn = "id";
            $sortDirection = $dataObj->request->order % 2 === 1 ? "ASC" : "DESC";   //单数升序 双数降序 0也为降序


            switch ($dataObj->request->order) {
                case 1:
                case 2:  // id 升序
                    $sortColumn = "id";
                    break;
                case 3:
                case 4:  // 排序 升序
                    $sortColumn = "sort";
                    break;
            }

            try {
                $result = Db()->name(app("cmsTable")::single_page_group())->order($sortColumn, $sortDirection)->field($dataObj->request->field)->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }



    /**获取全部信息
     * @param $paramObj
     * @return array
     */
    public function getAll($paramObj = ""): array
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {


            try {
                $result = Db()->name(app("cmsTable")::single_page_group())->field($dataObj->request->field)->select();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }
}