<?php

namespace app\db\admin;

class D_setting
{
    /**
     * 所有数据
     * @param string $paramObj
     */
    public function allData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'require|integer|gt:0',
                'format' => '',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $dataDefault["pid"]=0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->default=array();
            if(in_array($dataObj->request->pid,array(1,2,3,4))){
                //系统数据
                $dataObj->data->default=config("setting.{$dataObj->request->pid}",array());
            }else{
                //获取模型类型
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->pid,
                    "field"=>"module",
                );
                $checkResult=app("S_Admin_module")->info($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        $dataObj->data->default=config("setting.{$result["module"]}",$dataObj->data->default);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "pid","=",$dataObj->request->pid
            );
            try{
                $result=Db()->name(app("cmsTable")::setting())->field($dataObj->request->field)->where($condition)->select();
                if($dataObj->request->format=="keyValue" && $result){
                    $temp=array();
                    foreach($result as $val){
                        $temp[$val["itemKey"]]=$val["itemValue"];

                    }
                    $result=$temp;
                }
                if($dataObj->request->format=="keyValue" && $dataObj->data->default){
                    $result=array_merge($dataObj->data->default,$result);
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情 by itemKey
     * @param string $paramObj
     */
    public function infoByItemKey($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => '',
                'itemKey' => 'require',
                "pid"=>"",
                'field' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "itemKey","=",$dataObj->request->itemKey
            );
            if($dataObj->request->id){
                $condition[]=array(
                    "id","!=",$dataObj->request->id
                );
            }
            if($dataObj->request->pid){
                $condition[]=array(
                    "pid","=",$dataObj->request->pid
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::setting())->field($dataObj->request->field)->where($condition)->find();
                if($dataObj->request->verify){
                    if(empty($result)){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_NOT_EXIST,lang("sys.dataNotExists"));
                    }
                }
                if($final_arr["error_no"]==0 && $result){
                    $final_arr["result"]=$result;
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'name' => '',
                'itemKey' => 'require',
                'itemValue' => '',
                'pid' => 'integer',
                'note' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["pid"]=0;
            $dataDefault["itemValue"]="";
            $dataDefault["name"]="";
            $dataDefault["note"]="";
            $dataDefault["verify"]=1;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->verify){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "itemKey"=>$dataObj->request->itemKey,
                );
                $checkResult = $this->infoByItemKey($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_EXIST,lang("sys.dataExists"));
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $data=array();
                $data["name"]=$dataObj->request->name;
                $data["itemKey"]=$dataObj->request->itemKey;
                $data["itemValue"]=$dataObj->request->itemValue;
                $data["pid"]=$dataObj->request->pid;
                $data["note"]=$dataObj->request->note;
                $result=Db()->name(app("cmsTable")::setting())->data($data)->insert();
                $return=array();
                $return["id"]=$result["insert_id"];
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require|integer|gt:0',
                'name' => '',
                'itemKey' => '',
                'itemValue' => '',
                'pid' => 'integer',
                'note' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["verify"]=1;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->verify && isset($dataObj->request->itemKey)){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "itemKey"=>$dataObj->request->itemKey,
                    "id"=>$dataObj->request->id,
                );
                $checkResult = $this->infoByItemKey($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_EXIST,lang("sys.dataExists"));
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "id","=",$dataObj->request->id
            );
            $data=array();
            if(isset($dataObj->request->name)){
                $data["name"]=$dataObj->request->name;
            }
            if(isset($dataObj->request->itemKey)){
                $data["itemKey"]=$dataObj->request->itemKey;
            }
            if(isset($dataObj->request->itemValue)){
                $data["itemValue"]=$dataObj->request->itemValue;
            }
            if(isset($dataObj->request->pid)){
                $data["pid"]=$dataObj->request->pid;
            }
            if(isset($dataObj->request->note)){
                $data["note"]=$dataObj->request->note;
            }
            if($data){
                try{
                    $result=Db()->name(app("cmsTable")::setting())->where($condition)->data($data)->update();
                    $return=array();
                    $return["id"]=$dataObj->request->id;
                    $return["affected_rows"]=$result["affected_rows"];
                    $final_arr["result"]=$return;
                }catch (\Throwable $e){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
                }
            }else{
                $return=array();
                $return["id"]=$dataObj->request->id;
                $return["affected_rows"]=0;
                $final_arr["result"]=$return;
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
            );
            $dataDefault=array();
            $dataDefault["verify"]=1;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $ids=is_array($dataObj->request->id)?$dataObj->request->id:explode(",",$dataObj->request->id);
            $condition=array();
            $condition[]=array(
                "id","in",$ids
            );
            try{
                $result=Db()->name(app("cmsTable")::setting())->where($condition)->delete();
                $return=array();
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}