<?php

namespace app\db\admin;

use app\model\M_plugin_record;

class D_plugin_record
{
    /**
     * 信息格式化
     */
    private function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = $Result['updateTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']):"";
        }
        // 发送时间
        if (isset($Result['sendTime'])) {
            $Result['sendTimeFormat'] = $Result['sendTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['sendTime']):"";
        }
        // 回滚时间
        if (isset($Result['rollbackTime'])) {
            $Result['rollbackTimeFormat'] = $Result['rollbackTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['rollbackTime']):"";
        }
        // 有效时间
        if (isset($Result['days'])) {
            $Result['daysFormat'] = app("ltcmsFormat")->timeSecond($Result['days']);
        }
        // 是否发送
        if (isset($Result['isSend'])) {
            $isSendMap=array();
            $isSendMap["1"]="是";
            $isSendMap["0"]="否";
            $Result['isSendFormat'] = isset($isSendMap[$Result['isSend']])?$isSendMap[$Result['isSend']]:"";
        }
        // 是否回滚
        if (isset($Result['isRollback'])) {
            $isRollbackMap=array();
            $isRollbackMap["1"]="是";
            $isRollbackMap["0"]="否";
            $Result['isRollbackFormat'] = isset($isRollbackMap[$Result['isRollback']])?$isRollbackMap[$Result['isRollback']]:"";
        }
        // 发送类型
        if (isset($Result['deliveryType'])) {
            $deliveryTypeMap=array();
            $deliveryTypeMap["1"]="自动";
            $deliveryTypeMap["2"]="手动";
            $Result['deliveryTypeFormat'] = isset($deliveryTypeMap[$Result['deliveryType']])?$deliveryTypeMap[$Result['deliveryType']]:"";
        }
        // 有效期类型
        if (isset($Result['daysSelect'])) {
            $daysSelectMap=array();
            $daysSelectMap["1"]="系统";
            $daysSelectMap["2"]="自定义";
            $daysSelectMap["3"]="永久";
            $Result['daysSelectFormat'] = isset($daysSelectMap[$Result['daysSelect']])?$daysSelectMap[$Result['daysSelect']]:"";
        }
        // 返回结果
        return $Result;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault["verify"] = 1;
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::pluginRecord())->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    if($dataObj->request->format){
                        $result=$this->detailed($result);
                    }
                    $final_arr["result"] = $result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'guid' => 'require',
                'pluginId' => 'require',
                'domain' => 'require',
                'deliveryType' => 'require',
                'daysSelect' => 'require',
                'days_sys' => 'requireIf:daysSelect,1',
                'days_custom' => 'requireIf:daysSelect,2',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'condition' => array(
                    array(
                        "id","=",$dataObj->request->pluginId,
                    ),
                ),
                'field' => 'name',
                'table' => 'plugin',
                'resultField' => 'name',
            );
            $dataObj->data->pluginName=app("C_Common_row_data")->info($paramsObj);
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_plugin_record::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["pluginName"]=$dataObj->data->pluginName;
                if($dataObj->request->daysSelect=="1"){
                    $data["days"]=$dataObj->request->days_sys;
                }else if($dataObj->request->daysSelect=="2"){
                    $data["days"]=$dataObj->request->days_custom;
                }
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::pluginRecord())->insert($data);
                $return = array();
                $return["id"] = $result["insert_id"];
                $return["deliveryType"] = $data["deliveryType"];
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number',
                'daysSelect' => 'require',
                'deliveryType' => 'require',
                'days_sys' => 'requireIf:daysSelect,1',
                'days_custom' => 'requireIf:daysSelect,2',
                'pluginId' => '',
                'domain' => '',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->verify) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "id" => $dataObj->request->id,
                    "verify" => 1,
                );
                $checkResult = $this->info($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $fields=M_plugin_record::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if($dataObj->request->daysSelect=="1"){
                $data["days"]=$dataObj->request->days_sys;
            }else if($dataObj->request->daysSelect=="2"){
                $data["days"]=$dataObj->request->days_custom;
            }
            if ($data) {
                try {
                    $data["updateTime"] = app("ltcmsTime")::getTime();
                    $result = Db()->name(app("cmsTable")::pluginRecord())->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }

    /**
     * 发送| 回滚
     * @param string $paramObj
     */
    public function sendOrRollback($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number|gt:0',
                'isSend' => '',
                'isRollback' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $fields=M_plugin_record::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if ($data) {
                $nowTime=app("ltcmsTime")::getTime();
                if(isset($data["isSend"])){
                    $data["sendTime"]=$nowTime;
                }else{
                    $data["rollbackTime"]=$nowTime;
                }
                try {
                    $data["updateTime"] = $nowTime;
                    $result = Db()->name(app("cmsTable")::pluginRecord())->where($condition)->data($data)->update();
                    if($result["affected_rows"] >0){
                        $return = array();
                        $return["id"] = $dataObj->request->id;
                        $return["affected_rows"] = $result["affected_rows"];
                        $final_arr["result"] = $return;
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::pluginRecord())->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'guid' => '',
                'pluginId' => '',
                'domain' => '',
                'isSend' => '',
                'isRollback' => '',
                'deliveryType' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"]="*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->pluginId) {
                $condition[] = array(
                    "pluginId", "=", $dataObj->request->pluginId
                );
            }
            if ($dataObj->request->guid) {
                $condition[] = array(
                    "guid", "=", $dataObj->request->guid
                );
            }
            if ($dataObj->request->domain) {
                $condition[] = array(
                    "domain", "=", $dataObj->request->domain
                );
            }
            if ($dataObj->request->isSend) {
                $condition[] = array(
                    "isSend", "=", $dataObj->request->isSend
                );
            }
            if ($dataObj->request->isRollback) {
                $condition[] = array(
                    "isRollback", "=", $dataObj->request->isRollback
                );
            }
            if ($dataObj->request->deliveryType) {
                $condition[] = array(
                    "deliveryType", "=", $dataObj->request->deliveryType
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::pluginRecord())->field($dataObj->request->field)->order("id","desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}