<?php

namespace app\db;

class D_article
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['addTime'])) {
            $Result['addTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['addTime']);
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']);
        }
        // 文章模块
        if (isset($Result['moduleId'])) {
            $moduleIdFormat="";
            $moduleLinkUrl="";
            $moduleData=module($Result['moduleId']);
            if($moduleData){
                $moduleLinkUrl=moduleLinkUrl($moduleData);
                $moduleIdFormat=$moduleData["name"];
            }
            $Result["moduleIdFormat"]=$moduleIdFormat;
            $Result["moduleLinkUrl"]=$moduleLinkUrl;
        }
        // 文章分类
        if (isset($Result['categoryId'])) {
            $categoryIdFormat="";
            $categoryLinkUrl="";
            if($Result['categoryId']){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$Result['categoryId'],
                    "field"=>"name,dataType,dataId,linkurl",
                );
                $checkResult=app("S_Index_category")->info($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if($result){
                        $categoryLinkUrl=categoryLinkUrl($result);
                        $categoryIdFormat=$result["name"];
                    }
                }
            }
            $Result["categoryIdFormat"]=$categoryIdFormat;
            $Result["categoryLinkUrl"]=$categoryLinkUrl;
        }
        // 状态
        if (isset($Result['status'])) {
            $statusMap = array();
            $statusMap["1"] = "草稿";
            $statusMap["2"] = "待审核";
            $statusMap["3"] = "已发布";
            $Result['statusFormat'] = isset($statusMap[$Result['status']]) ? $statusMap[$Result['status']] : "";
        }
        // 内容
        if (isset($Result['articleContent'])) {
            $Result['articleContent'] = dstripslashes($Result['articleContent']);
        }
        // 查询推荐数据
        if (isset($Result['id']) && isset($Result['moduleId'])) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'dataId' => $Result['id'],
                'moduleId' => $Result['moduleId'],
            );
            $checkResult = app("S_Admin_commendModuleData")->getCommendData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $Result['levelData'] =$checkResult["result"];
            }
        }
        $Result["useLinkUrl"]=articleLinkUrl($Result);
        // 返回结果
        return $Result;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'id' => 'require',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["format"] = "1";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    if($dataObj->request->format){
                        $result=$this->detailed($result, $dataObj->request->format);
                    }
                    $final_arr["result"] = $result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

}