<?php

namespace app\controller\index;

use app\client\index\C_article;

class Article
{
    public $client;

    public function __construct()
    {
        $this->client = new C_article();
    }

    /**
     * 文章列表
     */
    public function index(){
        $this->initConfig("index");

        //获取模块数据
        $moduleId=request()->param("moduleId");
        $moduleData=$moduleId?module($moduleId):array();

        //获取模板配置
        $template_index=setting("template_index",$moduleId);
        $template=$template_index?$template_index:"index/article/index";
        
        $data=array();
        $data["module"]=$moduleData;
        $data["request"]=request()->param();
        return view($template,$data);
    }

    /**
     * 文章列表
     */
    public function lists(){
        $this->initConfig("index");

        $moduleId=request()->param("moduleId");
        $moduleData=$moduleId?module($moduleId):array();

        $catId=request()->param("catId");
        $categoryData=($moduleId && $catId)?category('module',$moduleId,$catId):array();
        $categoryData["linkUrl"]=$moduleData['linkUrl'].$categoryData['linkurl'];

        //获取模板配置
        $template_list=setting("template_list",$moduleId);
        $template=$template_list?$template_list:"index/article/list";

        $data=array();
        $data["module"]=$moduleData;
        $data["category"]=$categoryData;
        $data["request"]=request()->param();
        return view($template,$data);
    }

    /**
     * 文章详情
     */
    public function detail(){
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "id"=>request()->param("articleId"),
        );
        $response = $this->client->info($paramsObj);
        $articleData = array();
        if ($response["success"]) {
            $articleData = $response["data"];
        }
        $this->initConfig("detail",$articleData);

        $moduleId=request()->param("moduleId");
        $moduleData=$moduleId?module($moduleId):array();
        $categoryData=($moduleId && isset($articleData["categoryId"]) && $articleData["categoryId"])?category('module',$moduleId,$articleData["categoryId"]):array();
        $categoryData["linkUrl"]=$moduleData['linkUrl'].$categoryData['linkurl'];

        //获取模板配置
        $template_content=setting("template_content",$moduleId);
        $template=$template_content?$template_content:"index/article/detail";

        $data=array();
        $data["module"]=$moduleData;
        $data["article"]=$articleData;
        $data["category"]=$categoryData;
        $data["request"]=request()->param();
        return view($template,$data);
    }

    /**
     * 上传点击日志
     */
    public function uploadClickLogs(){
        $this->client->uploadClickLogs();
        $data=array();
        $data["request"]=request()->param();
        return json($data); //输出测试接口数据
    }

    /**
     *  配置初始化
     */
    public function initConfig($type,$articleData=null){
        //设置网站风格
        $moduleId=request()->param("moduleId","");
        if($moduleId){
            $moduleSetting=setting("",$moduleId);
            $siteSetting=siteSetting("");
            $seoSetting=seoSetting("");
            $moduleData=module($moduleId);

            //设置网站标题
            if($type){
                $keywords="";
                $description="";

                if($articleData){
                    $title="[内容标题][分隔符][网站名称]";
                    $keywords="[内容标题]";
                    $description="[文章简介]";
                }else{
                    $title="[模块名称][分隔符][网站名称]";
                }

                $page=request()->param("page",""); //页码
                $siteTitle=isset($siteSetting["siteTitle"])?$siteSetting["siteTitle"]:""; //网站名称
                $seoTitle=isset($seoSetting["seoTitle"])?$seoSetting["seoTitle"]:""; //网站SEO标题
                $moduleName=isset($moduleData["name"])?$moduleData["name"]:""; //模块名称
                $separator=isset($seoSetting["seoTitleSeparator"])?$seoSetting["seoTitleSeparator"]:""; //分隔符
                $seoDescription=isset($seoSetting["seoDescription"])?$seoSetting["seoDescription"]:""; //网站SEO描述
                $seoKeyword=isset($seoSetting["seoKeyword"])?$seoSetting["seoKeyword"]:""; //网站SEO关键字

                $map=array();
                $map["[模块名称]"]=$moduleName;
                $map["[分隔符]"]=$separator;
                $map["[网站SEO标题]"]=$seoTitle;
                $map["[网站名称]"]=$siteTitle;
                $map["[网站SEO关键字]"]=$seoKeyword;
                $map["[网站SEO描述]"]=$seoDescription;
                $map["[页码]"]=$page;
                $map["[内容标题]"]=($articleData && isset($articleData["title"]))?$articleData["title"]:"";
                $map["[分类名称]"]=($articleData && isset($articleData["categoryIdFormat"]))?$articleData["categoryIdFormat"]:"";
                $map["[文章简介]"]=($articleData && isset($articleData["description"]))?$articleData["description"]:"";

                $search=array();
                $replace=array();

                foreach($map as $mkey=>$mval){
                    $search[]=$mkey;
                    $replace[]=$mval;
                }

                //初始化
                $title=str_replace($search,$replace,$title);
                $keywords=str_replace($search,$replace,$keywords);
                $description=str_replace($search,$replace,$description);

                if($type=="index"){
                    if(isset($moduleSetting["moduleIndexTitle"]) && $moduleSetting["moduleIndexTitle"]){
                        $title=str_replace($search,$replace,$moduleSetting["moduleIndexTitle"]);
                    }
                    if(isset($moduleSetting["moduleIndexKeywords"]) && $moduleSetting["moduleIndexKeywords"]){
                        $keywords=str_replace($search,$replace,$moduleSetting["moduleIndexKeywords"]);
                    }
                    if(isset($moduleSetting["moduleIndexDescription"]) && $moduleSetting["moduleIndexDescription"]){
                        $description=str_replace($search,$replace,$moduleSetting["moduleIndexDescription"]);
                    }
                }else if($type=="detail"){
                    if(isset($moduleSetting["moduleDetailTitle"]) && $moduleSetting["moduleDetailTitle"]){
                        $title=str_replace($search,$replace,$moduleSetting["moduleDetailTitle"]);
                    }
                    if(isset($moduleSetting["moduleDetailKeywords"]) && $moduleSetting["moduleDetailKeywords"]){
                        $keywords=str_replace($search,$replace,$moduleSetting["moduleDetailKeywords"]);
                    }
                    if(isset($moduleSetting["moduleDetailDescription"]) && $moduleSetting["moduleDetailDescription"]){
                        $description=str_replace($search,$replace,$moduleSetting["moduleDetailDescription"]);
                    }
                }
                if($title){
                    config()->set("app.seo.title",$title);
                }
                if($keywords){
                    config()->set("app.seo.keywords",$keywords);
                }
                if($description){
                    config()->set("app.seo.description",$description);
                }
            }
        }
    }
}