<?php

namespace app\controller\admin;

use app\client\admin\C_setting;

class Setting
{
    public $c_setting;

    /**
     * @menuName 系统设置
     * 上面的是菜单的名字
     * @moduleName 系统设置
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_setting = new C_setting();
    }

    /**
     * 好像没用,只显示 222
     */
    public function index()
    {
        return view("admin/setting/index");
    }

    /**
     * @actionName  网站设置
     * @show 1
     * 展示设置
     */
    public function site()
    {
        $pid=1;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
            "format"=>"keyValue",
        );
        $response= $this->c_setting->allData($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        if(isset($result["copyright"])){
            $result["copyright"]=dstripslashes($result["copyright"]);
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        $data["pcDirList"]=config("template.default_pc_list");
        $data["mobileDirList"]=config("template.default_mobile_list");
        $data["skinList"]=config("template.default_skin_list");
        return view("admin/setting/site",$data);
    }

    /**
     * @actionName  扩展设置
     * @show 1
     * 扩展设置
     */
    public function extend()
    {
        $pid=4;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
            "format"=>"keyValue",
        );
        $response= $this->c_setting->allData($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $settingData=config("setting_data");
        $data=array();
        $data["settingData"] = $settingData;
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/extend",$data);
    }

    /**
     * @actionName  seo设置
     * @show 1
     * 展示设置
     */
    public function seo()
    {
        $pid=2;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
            "format"=>"keyValue",
        );
        $response= $this->c_setting->allData($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/seo",$data);
    }

    /**
     * @actionName  性能优化
     * @show 1
     * 展示设置
     */
    public function optimize()
    {
        $pid=3;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
            "format"=>"keyValue",
        );
        $response= $this->c_setting->allData($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/index_optimize",$data);
    }

    /**
     * @actionName  记录数据
     * @show 2
     * 展示设置
     */
    public function record()
    {
        $result= $this->c_setting->record();
        return jsonResponse($result);
    }

    /**
     * @actionName  记录数据批量
     * @show 2
     * 展示设置
     */
    public function recordBatch()
    {
        $setting=request()->param("setting");

        $listUrlRule=extendSetting("listUrlRule");
        $htmlListUrlRule=extendSetting("htmlListUrlRule");
        $htm_list_prefix=extendSetting("htm_list_prefix");
        $listHtml=extendSetting("listHtml");

        $conHtml=extendSetting("conHtml");
        $conUrlRule=extendSetting("conUrlRule");
        $htmlConUrlRule=extendSetting("htmlConUrlRule");
        $htm_item_prefix=extendSetting("htm_item_prefix");

        $categoryUpdata=0;
        if(!($listHtml==$setting["listHtml"] && $listUrlRule==$setting["listUrlRule"] && $htmlListUrlRule==$setting["htmlListUrlRule"] && $htm_list_prefix==$setting["htm_list_prefix"])){
            $categoryUpdata=1;
        }

        $articleUpdata=0;
        if(!($conHtml==$setting["conHtml"] && $conUrlRule==$setting["conUrlRule"] && $htmlConUrlRule==$setting["htmlConUrlRule"] && $htm_item_prefix==$setting["htm_item_prefix"])){
            $articleUpdata=1;
        }
        $result= $this->c_setting->recordBatch();
        if($result["success"]){
            if($categoryUpdata){
                //更新分类地址
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "dataType"=>"module",
                );
                app("S_Admin_category")->updateLinkurl($paramsObj);
            }
            if($articleUpdata){
                //获取模块数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "field"=>"id,module",
                );
                $checkResult=app("S_Admin_module")->allData($paramsObj);
                if($checkResult["error_no"]=="0"){
                    $moduleResult=$checkResult["result"];
                    if($moduleResult){
                        foreach($moduleResult as $mval){
                            if($mval["module"]=="article"){
                                //更新文章地址
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "moduleId"=>$mval["id"],
                                );
                                app("S_Admin_article")->updateLinkurl($paramsObj);
                            }
                        }
                    }
                }
            }
        }
        return jsonResponse($result);
    }

    /**
     * @actionName  删除数据
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result= $this->c_setting->delete();
        return jsonResponse($result);
    }
}