<?php

namespace app\controller\admin;

use app\client\admin\C_plugin_upgrade_log;

class Plugin_upgrade_log
{

    public $c_plugin_upgrade_log;

    /**
     * @menuName 软件商店
     * 上面的是菜单的名字
     * @moduleName 插件日志
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_plugin_upgrade_log = new C_plugin_upgrade_log();
    }

    /**
     * @actionName 详情
     * @show 2
     */
    public function info()
    {
        $result = $this->c_plugin_upgrade_log->info();
        return jsonResponse($result);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = $this->c_plugin_upgrade_log->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  添加
     * @show 2
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/plugin_upgrade_log/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "format"=>1,
        );
        $result = $this->c_plugin_upgrade_log->info($paramsObj);
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/plugin_upgrade_log/edit", $data);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = $this->c_plugin_upgrade_log->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     */
    public function delete()
    {
        $result = $this->c_plugin_upgrade_log->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  插件日志
     * @show 1
     */
    public function index()
    {
        $response = $this->c_plugin_upgrade_log->listData();
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/plugin_upgrade_log/index", $data);
    }
}