<?php

namespace app\controller\admin;

use app\client\admin\C_plugin_record;

class Plugin_record
{

    public $c_plugin_record;

    /**
     * @menuName 软件商店
     * 上面的是菜单的名字
     * @moduleName 插件记录
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_plugin_record = new C_plugin_record();
    }

    /**
     * @actionName 详情
     * @show 2
     */
    public function info()
    {
        $result = $this->c_plugin_record->info();
        return jsonResponse($result);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = $this->c_plugin_record->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  添加
     * @show 2
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/plugin_record/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "format"=>1,
        );
        $result = $this->c_plugin_record->info($paramsObj);
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/plugin_record/edit", $data);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = $this->c_plugin_record->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     */
    public function delete()
    {
        $result = $this->c_plugin_record->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  插件记录
     * @show 1
     */
    public function index()
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "format"=>"1",
        );
        $response = $this->c_plugin_record->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/plugin_record/index", $data);
    }

    /**
     * 发送操作
     */
    public function send()
    {
        $result = $this->c_plugin_record->send();
        return jsonResponse($result);
    }

    /**
     * 回滚-发送操作
     */
    public function rollback()
    {
        $result = $this->c_plugin_record->rollback();
        return jsonResponse($result);
    }
}