<?php

namespace app\controller\admin;

use app\client\admin\C_plugin;

class Plugin
{

    public $c_plugin;

    /**
     * @menuName 软件商店
     * 上面的是菜单的名字
     * @moduleName 软件列表
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_plugin = new C_plugin();
    }

    /**
     * @actionName 详情
     * @show 2
     */
    public function info()
    {
        $result = $this->c_plugin->info();
        return jsonResponse($result);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = $this->c_plugin->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  添加
     * @show 2
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/plugin/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $result = $this->c_plugin->info();
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/plugin/edit", $data);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = $this->c_plugin->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     */
    public function delete()
    {
        $result = $this->c_plugin->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  插件列表
     * @show 1
     */
    public function index()
    {
        $response = $this->c_plugin->listData();
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/plugin/index", $data);
    }
}