<?php

namespace app\controller\admin;

use app\client\admin\C_articleType;
use app\client\admin\C_setting;
use app\logic\admin\L_systemUpdate;
use app\logic\admin\L_user;

class Index extends Init
{

    /**
     * @menuName 无菜单
     * 上面的是菜单的名字
     * @moduleName 默认
     * 上面的是控制器的名字
     */
    public function __construct()
    {

    }
    /**
     * @actionName 默认框架
     * @show 2
     * 展示设置
     */
    public function index()
    {
        $menuIdsInfoJson = $funcIdsInfoJson = "";
        $checkResult = (new L_user())->getUserMenu();
        if ($checkResult["error_no"] == 0) {
            $menuIdsInfoJson = json_encode($checkResult["result"]["menuIdsInfo"]);
            $funcIdsInfoJson = json_encode($checkResult["result"]["funcIdsInfo"]);
        }
        $data = array();
        $data["menuIdsInfoJson"] = $menuIdsInfoJson;
        $data["funcIdsInfoJson"] = $funcIdsInfoJson;
        $data["request"] = request()->param();
        return view("admin/layout/index", $data);
    }

    /**
     * @actionName 默认页面
     * @show 2
     * 展示设置
     */
    public function welcome()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "pid" => 1,
            "format" => "keyValue",
        );
        $c_setting = new C_setting();
        $response = $c_setting->allData($paramsObj);
        $result = array();
        if ($response["success"]) {
            $result = $response["data"];
        }

//        $newVersion = cache()->get("newVersion");
//        if (!$newVersion) {
//            (new L_systemUpdate)->getNewVersion();
//            $newVersion = cache()->get("newVersion") ?? "待检测";
//        }

        $sysInfo = app("L_Admin_welcome")->sysInfo();
        $definedFunctions = get_defined_functions();
        $loadedMethods = $definedFunctions['user'];
        $isAuthorized = "未授权";

        //mark  暂时这样处理,正确方式应该是 调用鉴权文件中的,读取key函数 获得授权授权域名和信息数组,这样不暴露aes密钥,
        if (is_file(LTCMS_ROOT . "/key.txt")) {
            $Token = file_get_contents(LTCMS_ROOT . "/key.txt");
            if (strlen($Token) > 2 && strlen($Token) % 2 == 0) {
                try {
                    $Token = hex2bin($Token);
                    $Token = openssl_decrypt($Token, 'AES-128-ECB', "wl!cms#$%^&+_)()", OPENSSL_RAW_DATA);
                    $Token = explode(".", $Token);
                    $Token = json_decode(base64_decode($Token[1]), true);
                    $isAuthorized = "到期时间:" . date('Y-m-d H:i:s', $Token["exp"]);
                } catch (\Exception $e) {

                }
            }
        }

        $data = array();
        $data["rowData"] = $result;
        $data["sysInfo"] = $sysInfo;
        $data["isAuthorized"] = $isAuthorized;
        $data["cmsSystemUrl"] = (new L_systemUpdate)->cmsSystemUrl;
        $data["version"] = app("L_Common_version")->info();
        $data["request"] = request()->param();
        return view("admin/default/welcome", $data);
    }
}