<?php

namespace app\controller\admin;

use app\client\admin\C_adminMenu;


class AdminMenu
{
    public $client;

    /**
     * @menuName 后台权限
     * 上面的是菜单的名字
     * @moduleName 菜单管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_adminMenu();
    }

    /**
     * @actionName  添加接口
     * @show 2
     * 上面是否显示到菜单
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  添加页
     * @show 2
     * 上面是否显示到菜单
     */
    public function create()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $result = $this->client->getAllKeyVal();
        if ($result["success"]) {
            $result = $result["data"];
        }

        $data = array();
        $data["adminMenuVal"] = $result;
        $data["request"] = request()->param();
        return view("admin/adminMenu/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 上面是否显示到菜单
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        if ($result["success"]) {
            $info = $result["data"];
        }

        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $result = $this->client->getAllKeyVal();
        if ($result["success"]) {
            $adminMenuVal = $result["data"];
        }

        $data = array();
        $data["info"] = $info;
        $data["adminMenuVal"] = $adminMenuVal;
        $data["request"] = request()->param();

        return view("admin/adminMenu/edit", $data);
    }

    /**
     * @actionName  更新
     * @show 2
     * 上面是否显示到菜单
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     * 上面是否显示到菜单
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  菜单管理
     * @show 1
     * 上面是否显示到菜单
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/adminMenu/index", $data);
    }
}