<?php

namespace app\controller\admin;

use app\client\admin\C_adminFunc;
use app\client\admin\C_adminMenu;
use app\logic\admin\L_adminFunc;
use ReflectionClass;


class AdminFunc
{
    public $client;

    /**
     * @menuName 后台权限
     * 上面的是菜单的名字
     * @moduleName 后台功能
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_adminFunc();
    }

    /**
     * @actionName 添加接口
     * @show 2
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加页
     * @show 2
     */
    public function create()
    {

        $result = (new C_adminMenu())->getAllKeyVal();
        if ($result["success"]) {
            $adminMenuVal = $result["data"];
        }
        $data = array();
        $data["adminMenuVal"] = $adminMenuVal ?? array();
        $data["request"] = request()->param();
        return view("admin/adminFunc/create", $data);
    }

    /**
     * @actionName  编辑页
     * @show 2
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        if ($result["success"]) {
            $Info = $result["data"];
        }

        $result = (new C_adminMenu())->getAllKeyVal();
        if ($result["success"]) {
            $adminMenuVal = $result["data"];
        }

        $data = array();
        $data["info"] = $Info;
        $data["adminMenuVal"] = $adminMenuVal;
        $data["request"] = request()->param();

        return view("admin/adminFunc/edit", $data);
    }

    /**
     * @actionName 更新
     * @show 2
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  后台功能
     * @show 1
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/adminFunc/index", $data);
    }

    /**
     * @actionName 刷新控制器功能列表
     * @show 2
     */
    public function updateControllerFunctionList()
    {
        $result = $this->client->updateControllerFunctionList();
        return jsonResponse($result);
    }
    /**
     * @actionName 清空
     * @show 2
     */
    public function deleteAll()
    {
        $result = $this->client->deleteAll();
        return jsonResponse($result);
    }

}