<?php

namespace app\controller\admin;

use app\client\admin\C_adPosition;



//广告位管理
class AdPosition
{

    public $client;

    /**
     * @menuName 拓展管理
     * 上面的是菜单的名字
     * @moduleName 广告位管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_adPosition();
    }


    /**
     * @actionName 读取详情
     * @show 2
     * 展示设置
     */
    public function info()
    {
        $result = $this->client->info();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName 广告位添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/adPosition/create", $data);
    }

    /**
     * @actionName  广告位编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        if ($result["success"]) {
            $result = $result["data"];
        }

        $data = array();
        $data["info"] = $result;
        $data["request"] = request()->param();

        return view("admin/adPosition/edit", $data);
    }

    /**
     * @actionName 更新
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  广告位管理
     * @show 1
     * 展示设置
     */
    public function index()
    {


        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }

        $data = array();


        $data["rowData"] = $rowData;
        $data["request"] = request()->param();


        return view("admin/adPosition/index", $data);
    }
}