<?php

namespace app\client\admin;

class C_plugin_record
{
    /**
     * 发送操作
     * @param string $paramObj
     */
    public function send($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_plugin_record")->send($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 回滚-发送操作
     * @param string $paramObj
     */
    public function rollback($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_plugin_record")->rollback($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_plugin_record")->store($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result["deliveryType"]=="1"){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$result["id"],
                );
                $response= $this->send($paramsObj);
                if(!$response["success"]){
                    return $response;
                }
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_plugin_record")->update($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_plugin_record")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj->params = array(
            "format"=>1,
        );
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_plugin_record")->listData($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 读取资源
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_plugin_record")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}