<?php

namespace app\client\admin;

class C_goods
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $messages=array();
        $messages["name.require"]="请输入商品名称";
        $messages["_goodsNo.require"]="请输入商品货号";
        $messages["_sellPrice.require"]="请输入销售价";
        $messages["_marketPrice.require"]="请输入市场价";
        $messages["_costPrice.requireIf"]="请输入成本价";
        $messages["_storeNums.requireIf"]="请输入库存";
        $messages["_weight.requireIf"]="请输入重量";
        $messages["unit.requireIf"]="请输入计量单位";
        $messages["_virtualConfig.requireIf"]="请添加虚拟商品";
        $messages["_virtualType.requireIf"]="请添加虚拟商品";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_goods")->store($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $messages=array();
        $messages["name.require"]="请输入商品名称";
        $messages["_goodsNo.require"]="请输入商品货号";
        $messages["_sellPrice.require"]="请输入销售价";
        $messages["_marketPrice.require"]="请输入市场价";
        $messages["_costPrice.requireIf"]="请输入成本价";
        $messages["_storeNums.requireIf"]="请输入库存";
        $messages["_weight.requireIf"]="请输入重量";
        $messages["unit.requireIf"]="请输入计量单位";
        $messages["_virtualConfig.requireIf"]="请添加虚拟商品";
        $messages["_virtualType.requireIf"]="请添加虚拟商品";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_goods")->update($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_goods")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj->params = array(
            "format"=>1,
        );
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_goods")->listData($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 读取资源
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_goods")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}