<?php

namespace app\client\admin;

class C_adminFunc
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->store($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->update($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->delete($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }


    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->listData($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 读取资源
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->info($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 读取资源kv
     * @param string $paramObj
     */
    public function getAllKeyVal($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Admin_adminFunc")->getAllKeyVal($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 刷新控制器功能列表
     * @param string $paramObj
     */
    public function updateControllerFunctionList($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Admin_adminFunc")->updateControllerFunctionList($paramsObj);
        if ($checkResult["error_no"] == 0) {
            //["count" => $总数, "UpdateEqually" => $数据相同, "UpdateOk" => $更新成功, "UpdateFail" => $更新失败, "insertOk" => $插入成功, "insertFail" => $插入失败]
            $a = $checkResult["result"];
            $msg = "扫描总数:" . $a["count"] . ",\n数据相同:" . $a["UpdateEqually"];
            $msg .= ",\n更新成功:" . $a["UpdateOk"] . ",\n更新失败:" . $a["UpdateFail"] . ",\n插入成功:" . $a["insertOk"] . ",\n插入失败:" . $a["insertFail"];
            return apiResult(true, $msg, 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }


    /**
     * 清空数据
     * @param string $paramObj
     */
    public function deleteAll($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adminFunc")->deleteAll($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
}