<?php

namespace app\client\admin;

use app\logic\admin\L_adManage;

class C_adManage
{
    public $L_adManage;

    public function __construct()
    {
        $this->L_adManage = new L_adManage();
    }

    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult= $this->L_adManage->store($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult= $this->L_adManage->update($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_adManage")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Admin_adManage")->listData($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 读取资源
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_adManage")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}