var sdkConfig = (function(){
    var sdkConfigObj={};
    sdkConfigObj.defaults=
    {
        GAMEID:0,
        APPID:1,
        APPKEY:""
    };
    sdkConfigObj.getGameId=function()
    {
        return sdkConfigObj.defaults.GAMEID;
    };
    sdkConfigObj.setGameId=function(val)
    {
        if(val)
        {
            sdkConfigObj.defaults.GAMEID=val;
        }
        return sdkConfigObj.defaults.GAMEID;
    };
    sdkConfigObj.getAppId=function()
    {
        return sdkConfigObj.defaults.APPID;
    };
    sdkConfigObj.setAppId=function(val)
    {
        if(val)
        {
            sdkConfigObj.defaults.APPID=val;
        }
        return sdkConfigObj.defaults.APPID;
    };
    sdkConfigObj.getAppKey=function()
    {
        return sdkConfigObj.defaults.APPKEY;
    };
    sdkConfigObj.setAppKey=function(val)
    {
        if(val)
        {
            sdkConfigObj.defaults.APPKEY=val;
        }
        return sdkConfigObj.defaults.APPKEY;
    };
    return sdkConfigObj;
})();

(function ($, window, document,undefined)
{
    $.extend({
        getDefineValue:function(val,deault)
        {
            var result;
            if("undefined" ==  typeof val)
            {
                if("undefined" ==  typeof deault)
                {
                    result="";
                }
                else
                {
                    result=deault;
                }
            }
            else
            {
                result=val;
            }
            return result;
        },
        objToArr:function(obj)
        {
            var arr = new Array(2);
            var a=0;
            arr["keys"]=[];
            arr["value"]=[];
            for ( i in obj)
            {
                arr["keys"][a]=i; //键名
                arr["value"][a]=obj[i]; //值
                a++;
            }
            return arr;
        },
        isMobile:function ()
        {
            if((navigator.userAgent.match(/(phone|pad|pod|iPhone|iPod|ios|iPad|Android|Mobile|BlackBerry|IEMobile|MQQBrowser|JUC|Fennec|wOSBrowser|BrowserNG|WebOS|Symbian|Windows Phone)/i)))
            {
                return true;
            }
            else
            {
                return false;
            }
        },
        mdData:function(curlDataMd,curlData)
        {
            if(curlDataMd)
            {
                var curlDataMdArr=curlDataMd.split(",");
                if(curlDataMdArr.length>0)
                {
                    for(var i=0;i<curlDataMdArr.length;i++)
                    {
                        if(typeof curlData[curlDataMdArr[i]] !="undefined")
                        {
                            curlData[curlDataMdArr[i]]= $.md5(curlData[curlDataMdArr[i]]);
                        }
                    }
                }
            }
            return curlData;
        },
        signType:function (signType,curlData)
        {
            if(signType)
            {
                if(signType==1)
                {
                    var signParams={"appId":sdkConfig.getGameId(),"api_identifier":sdkConfig.getAppId()};
                    $.extend(curlData, signParams);
                    curlData.signature=$.signFunc(curlData);
                }
            }
            return curlData;
        },
        signSort:function (signData)
        {
            var arr=$.objToArr(signData);
            var keys=arr.keys;
            keys.sort();
            if(keys.length)
            {
                var signArr=[];
                for(var i=0;i<keys.length;i++)
                {
                    var keyName=keys[i];
                    signArr[i]=decodeURIComponent(signData[keyName]);
                }
                return signArr.join("|");
            }
            else
            {
                return "";
            }
        },
        signFunc:function (signData)
        {
            var signStr=$.signSort(signData);
            signStr=signStr+"|"+sdkConfig.getAppKey();
            //console.log("signStr:"+signStr);
            return $.md5(signStr);
        },
        arrToJson:function(data)
        {
            var f = {};//声明一个对象
            $.each(data,function(index,field){
                f[field.name] = field.value;//通过变量，将属性值，属性一起放到对象中
            });
            return f;
        },
        jsonToStr:function(data)
        {
            var f = "";//声明一个对象
            $.each(data,function(index,field){
                // f[field.name] = field.value;//通过变量，将属性值，属性一起放到对象中
                f+=index+"="+field+"&";
            });
            f=$.rtrim(f);
            return f;
        },
        rtrim:function(str)
        {
            return str.replace(/(&*$)/g,"");
        },
        getQuery:function()
        {
            var url=location.search;
            var Request = new Object();
            if(url.indexOf("?")!=-1)
            {
                var str = url.substr(1);　//去掉?号
                strs = str.split("&");
                for(var i=0;i<strs.length;i++)
                {
                    Request[strs[i].split("=")[0]]=decodeURI(strs[i].split("=")[1]);
                }
            }
            return Request;
        },
        setCookie:function (name,value,timeOut)
        {
            var temptime=timeOut?timeOut:86400;
                temptime=temptime*1000;
            var exp = new Date();
            exp.setTime(exp.getTime() + temptime);
            document.cookie = $.trim(name) + "=" + encodeURI($.trim(value)) + ";expires=" + exp.toGMTString() + ";path=/";
        },
        getCookie:function (name)
        {
            var strcookie=document.cookie;
            var getMatchCookie="";
            var arrCookie=strcookie.split(";");
            for(var i=0;i<arrCookie.length;i++)
            {
                var arr=arrCookie[i].split("=");
                if($.trim(name) == $.trim(arr[0]))
                {
                    getMatchCookie = $.trim(arr[1]);
                    break;
                }
            }
            return getMatchCookie;
        },
        deleteCookie:function (name)
        {
            var exp = new Date();
            exp.setTime(exp.getTime() - 1);
            document.cookie = $.trim(name) + "=;expires=" + exp.toUTCString();
        },
        waitTime:function (obj,time,mobileObj)
        {
            if(obj.status!="inited")
            {
                obj.oldTime=time;
                $(obj).attr("status","start");
            }
            obj.status="inited";
            mobileObj=$.getDefineValue(mobileObj,"");

            if (time == 0)
            {
                obj.status="reset";
                $(obj).find('.wz').html("获取验证码");
                $(obj).addClass("cur");
                $(obj).attr("status","end");
                if(mobileObj)
                {
                    $(mobileObj).attr("disabled",false);
                }
            }
            else
            {
                if(mobileObj)
                {
                    $(mobileObj).attr("disabled",true);
                }
                $(obj).removeClass("cur");
                $(obj).find('.wz').html("重新发送(" + time + ")");
                time--;
                setTimeout(function(){
                    $.waitTime(obj,time,mobileObj);
                },1000);
            }
        }
    });
})(jQuery, window, document);
