$(function () {
    $(document).on("click", ".login_fields__submit", function () {
        // let msgIndex = layer.msg('正在登录', {
        //     icon: 16,
        //     shade: 0.05,
        //     time:15000
        // });
        var url = $(this).attr("data-submit-url");
        $(".loginForm").commonSubmit({"clickObj": $(this), "url": url, "callback": "loginRs", "data": {}});
    });

    $(document).on("click", ".ajaxBtn", function (event) {
        event.stopPropagation();
        // let msgIndex = layer.msg('正在处理', {
        //     icon: 16,
        //     shade: 0.05,
        //     time:15000
        // });
        var url = $(this).attr("data-submit-url");
        var data_form = $(this).attr("data-form");
        var param = $(this).attr("data-param") ? $.parseJSON($(this).attr("data-param")) : {};
        $(data_form).commonSubmit({"clickObj": $(this), "url": url, "callback": "ajaxRs", "data": param});
    });

    $(document).on("click", ".categoryNav span", function () {
        var index=$(this).index();
        var id=$(this).data("id");
        $(this).parents(".categoryBox").find(".categoryNav span").removeClass("active");
        $(this).addClass("active");
        $(this).parent().parent().siblings(".categoryCon").hide();
        $(this).parent().parent().siblings(".categoryCon").eq(index).show();
        $(this).parents(".categoryBox").find(".pid").val(id);
        $(this).parents(".categoryBox").find(".pid").trigger("click");
        selectPreRecursion(this);
    });

    /**
     * 向上选择递归
     */
    function selectPreRecursion(obj){
        var index=$(obj).parent().parent().parent().parent().index() -1;
        var span=$(obj).parent().parent().parent().parent().siblings(".categoryNav").find("span");
        $(span).removeClass("active");
        $(span).eq(index).addClass("active");
        if(index >=0){
            selectPreRecursion($(span));
        }
    }

    $(document).on("mouseover mouseout", ".hoverBox", function (event) {
        if (event.type == "mouseover") {
            //鼠标悬浮
            $(this).find(".hoverContent").show();
        } else if (event.type == "mouseout") {
            //鼠标离开
            $(this).find(".hoverContent").hide();
        }
    });

    $(document).on("keyup", ".loginForm", function () {
        if (event.keyCode == 13) {
            $(this).find(".login_fields__submit").trigger("click");
        }
    });
    $(document).on("submit", ".loginForm", function (event) {
        return false;
    });
    $(document).on("submit", ".ajaxForm", function (event) {
        return false;
    });
    $(document).on("keyup", ".ajaxForm", function (event) {
        var type=event.target.type;
        if (event.keyCode == 13 && type !="textarea") {
            $(".ajaxBtn").trigger("click");
        }
    });

    $(document).on("change click", ".switch_btn", function () {
        var index=$(this).data("index");
        $(this).parents(".switchContainer").find(".switchBox").hide();
        $(this).parents(".switchContainer").find(".switch_box_"+index).show();
    });

    $(document).on("click", ".openFiles", function () {
        var open=$(this).data("open");
        if(open=="1"){
            $(this).data("open","0");
            $(this).closest(".box").find(".child").hide();
        }else{
            $(this).data("open","1");
            $(this).closest(".box").find(".child").show();
        }
    });

    $(document).on("click", ".fileCheck", function () {
        var checked=$(this).is(":checked");
        if(checked){
            $(this).closest(".box").find(".child").find(".fileCheck").prop('checked', true);
        }else{
            $(this).closest(".box").find(".child").find(".fileCheck").prop('checked', false);
        }
    });

    $(document).on("click", ".nextFileList", function () {
        var isCheck=$(this).siblings(".fileCheck").is(":checked");
        var file=$(this).data("file");
        var index=$(this).data("index");
        var param = {"dir":file,"level":index+1,"isCheck":isCheck?1:0};
        var url="/api/file/files";
        var isLoad=$(this).attr("isLoad");
        if(isLoad != 1){
            $(this).attr("isLoad","1");
            $("none").commonSubmit({"clickObj": $(this), "url": url, "callback": "fileRs", "data": param});
        }
    });

    //图片点击放大功能-关闭
    $(document).on("click", ".scale_img_bg", function () {
       $(".show_img").remove();
    });
});

function scale_img(self){
    var html="";
    var img=$(self).attr("src");
    if(img){
        html+='<div class="show_img" style="width:100%;height:100%;position: fixed;z-index:9999;padding:0;margin:0;">'
            +'<div  class="scale_img_bg" style="width:100%;height:100%;position: absolute;background-color: #000000;z-index:-1;opacity: 0.5;padding:0;margin:0;" ></div>'
            +'<img src="'+img+'" style="z-index:2;max-width:800px;max-height:400px;position: absolute;top: 50%;left: 50%;transform: translate(-50%, -50%);" />'
            +'</div>';
    }
    $(".show_img").remove();
    $("body").prepend(html);
    return html;
}

function _into(name,value){
    var tmp=$("input[name='setting["+name+"]']").val();
    $("input[name='setting["+name+"]']").val(tmp+value);
}

/**
 * 切换语言
 */
function changeLang(obj) {
    var localUrl = $(obj).attr("_localUrl") + $(obj).val();
    $("#none").commonSubmit({"clickObj": $(obj), "url": localUrl, "callback": "ajaxRs", "data": {}});
}

/**
 * ajax响应
 * @param flag
 * @param curForm
 * @param xhr
 */
function ajaxRs(flag, curForm, xhr) {
    // layer.close()  //关闭加载中提示框,如果有
    if (flag == 1) //请求成功 数据解析正确
    {
        if (xhr.success) {
            var referer= typeof (xhr.extra.referer) === "undefined" ? "" : xhr.extra.referer;
            if(referer){
                window.self.location = referer;
            }else{
                var clickObj = curForm.options.clickObj;

                var location_url = clickObj.attr("data-location-url");
                location_url = typeof (location_url) === "undefined" ? "" : location_url;

                var data_close = clickObj.attr("data-close");
                data_close = typeof (data_close) === "undefined" ? "" : data_close;
                if (data_close == "1") { //重新加载上一页
                    window.parent.location.reload();
                } else if (data_close == "2") { //重新加载当前页
                    window.location.reload();
                } else if (data_close == "3") {  //提示并重新加载当前页
                    layer.msg(xhr.codeMsg, {icon: 1, time: 1000});
                    window.location.reload();
                } else if (data_close == "4") {
                    layer.msg(xhr.codeMsg, {icon: 1, time: 1000});
                    $(clickObj).closest('tr').remove();
                } else if (data_close == "5") {
                    layer.msg(xhr.codeMsg, {icon: 1, time: 1000});
                    if (location_url) {
                        window.self.location = location_url;
                    }else if (document.referrer) {
                        window.self.location = document.referrer;
                    }
                } else if (data_close == "6") { //只提示
                    layer.msg(xhr.codeMsg, {icon: 1, time: 1000});
                } else {
                    if (location_url) {
                        window.location.href = location_url;
                    }
                }
            }
        } else {
            layer.msg(xhr.codeMsg);
        }
    }else if(flag == 3) {
        if(xhr.readyState !="4"){
            console.log(xhr.statusText);
        }
    }
}

/**
 * 登录数据
 * @param flag
 * @param curForm
 * @param xhr
 */
function loginRs(flag, curForm, xhr) {
    layer.close()
    if (flag == 1) //请求成功 数据解析正确
    {
        if (xhr.success) {
            window.location.href = curForm.options.clickObj.attr("data-location-url");
        } else {
            layer.msg(xhr.codeMsg);
        }
    }
}

/**
 * 文件响应
 * @param flag
 * @param curForm
 * @param xhr
 */
function fileRs(flag, curForm, xhr) {
    if (flag == 1) //请求成功 数据解析正确
    {
        if (xhr.success) {
            $(curForm.options.clickObj).data("open","1");
            $(curForm.options.clickObj).addClass("openFiles");
            $(curForm.options.clickObj).removeClass("nextFileList");
            $(curForm.options.clickObj).closest(".box").append(xhr.data);
        } else {
            $(this).attr("isLoad","0");
            layer.msg(xhr.codeMsg);
        }
    }
}

/*
 单行删除
 */
function dataRowDel(obj) {
    layer.confirm(arrLang[lang]["publicAskDelete"], {
        btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
        title: arrLang[lang]["message"]
    }, function (index) {
        var data_submit_url = $(obj).attr("data-submit-url");
        $(".nobody").commonSubmit({"clickObj": $(obj), "url": data_submit_url, "callback": "ajaxRs"});
    });
}

/*
 批量删除
 */
function dataMoreDel(obj) {
    var ids = new Array();
    $("input[name='check_id']:checked").each(function () {
        ids.push(this.value);
    });
    ids = ids.join(',');
    if (ids) {
        var data_alert = $(obj).attr("data-alert");
        data_alert = typeof (data_alert) === "undefined" ? arrLang[lang]["publicAskDeleteMore"] : data_alert;

        layer.confirm(data_alert, {
            btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
            title: arrLang[lang]["message"]
        }, function (index) {
            var data_submit_url = $(obj).attr("data-submit-url");
            var data_method = $(obj).attr("data-method");
            data_method = typeof (data_method) === "undefined" ? "" : data_method;
            if (data_method) {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    type: "POST",
                    data: {"id": ids, "_method": data_method}
                });
            } else {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    "data": {"id": ids}
                });
            }
        });
    } else {
        layer.msg(arrLang[lang]["publicPleaseSelectDataFirst"], {icon: 2, time: 1000});
    }
}

/*
 批量生成单页
 */
function dataMoreGenerate(obj) {
    var ids = new Array();
    $("input[name='check_id']:checked").each(function () {
        ids.push(this.value);
    });
    ids = ids.join(',');
    if (ids) {
        layer.confirm(arrLang[lang]["publicAskGenerateMore"], {
            btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
            title: arrLang[lang]["message"]
        }, function (index) {
            var data_submit_url = $(obj).attr("data-submit-url");
            var data_method = $(obj).attr("data-method");
            data_method = typeof (data_method) === "undefined" ? "" : data_method;
            if (data_method) {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    type: "POST",
                    data: {"id": ids, "_method": data_method}
                });
            } else {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    "data": {"id": ids}
                });
            }
        });
    } else {
        layer.msg(arrLang[lang]["publicPleaseSelectDataFirst"], {icon: 2, time: 1000});
    }
}
/*
 批量删除Guid
 */
function dataMoreDelGuid(obj) {
    var ids = new Array();
    $("input[name='check_id']:checked").each(function () {
        ids.push(this.value);
    });
    ids = ids.join(',');
    if (ids) {
        layer.confirm(arrLang[lang]["publicAskDeleteMore"], {
            btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
            title: arrLang[lang]["message"]
        }, function (index) {
            var data_submit_url = $(obj).attr("data-submit-url");
            var data_method = $(obj).attr("data-method");
            data_method = typeof (data_method) === "undefined" ? "" : data_method;
            if (data_method) {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    type: "POST",
                    data: {"guid": ids, "_method": data_method}
                });
            } else {
                $(".nobody").commonSubmit({
                    "clickObj": $(obj),
                    "url": data_submit_url,
                    "callback": "ajaxRs",
                    "data": {"guid": ids}
                });
            }
        });
    } else {
        layer.msg(arrLang[lang]["publicPleaseSelectDataFirst"], {icon: 2, time: 1000});
    }
}

/*
 请求 API
 */
function runApi(obj) {
    var data_form = $(obj).attr("data-form");
    data_form = typeof (data_form) === "undefined" ? "" : data_form;
    var data_alert_cs = $(obj).attr("data-alert");
    data_alert = typeof (data_alert_cs) === "undefined" ? arrLang[lang]["publicAskSureExec"] : arrLang[lang][data_alert_cs];
    if(!data_alert){
        data_alert=data_alert_cs;
    }
    var data_submit_url = $(obj).attr("data-submit-url");
    data_submit_url = typeof (data_submit_url) === "undefined" ? "" : data_submit_url;
    var data_method = $(obj).attr("data-method");
    data_method = typeof (data_method) === "undefined" ? "" : data_method;
    if (data_submit_url) {
        layer.confirm(data_alert, {
            btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
            title: arrLang[lang]["message"]
        }, function (index) {
            //加载中 动画效果,防止客户以为没点击,重复点击
            // let msgIndex = layer.msg('loading...', {
            //     icon: 16,
            //     shade: 0.05,
            //     time: 60000
            // });
            if (data_form) {
                $(data_form).commonSubmit({"clickObj": $(obj), "url": data_submit_url, "callback": "ajaxRs"});
            } else {
                if (data_method) {
                    $(".nobody").commonSubmit({
                        "clickObj": $(obj),
                        "url": data_submit_url,
                        "callback": "ajaxRs",
                        type: "POST",
                        data: {"_method": data_method}
                    });
                } else {
                    $(".nobody").commonSubmit({"clickObj": $(obj), "url": data_submit_url, "callback": "ajaxRs"});
                }
            }
        });
    } else {
        layer.msg(arrLang[lang]["publicSystemException"], {icon: 2, time: 1000});
    }
}

/*
 请求 API[批量处理]
 */
function runBatchApi(obj) {
    var ids = new Array();
    $("input[name='check_id']:checked").each(function () {
        ids.push(this.value);
    });
    ids = ids.join(',');
    if (ids) {
        var data_form = $(obj).attr("data-form");
        data_form = typeof (data_form) === "undefined" ? "" : data_form;
        var data_alert = $(obj).attr("data-alert");
        data_alert = typeof (data_alert) === "undefined" ? arrLang[lang]["publicAskSureExec"] : arrLang[lang][data_alert];
        var data_submit_url = $(obj).attr("data-submit-url");
        data_submit_url = typeof (data_submit_url) === "undefined" ? "" : data_submit_url;
        var data_method = $(obj).attr("data-method");
        data_method = typeof (data_method) === "undefined" ? "" : data_method;
        if (data_submit_url) {
            layer.confirm(data_alert, {
                btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
                title: arrLang[lang]["message"]
            }, function (index) {
                if (data_form) {
                    $(data_form).commonSubmit({"clickObj": $(obj), "url": data_submit_url, "callback": "ajaxRs",data: {"id": ids}});
                } else {
                    if (data_method) {
                        $(".nobody").commonSubmit({"clickObj": $(obj),"url": data_submit_url,"callback": "ajaxRs",type: "POST",data: {"id": ids,"_method": data_method}
                        });
                    } else {
                        $(".nobody").commonSubmit({"clickObj": $(obj), "url": data_submit_url, "callback": "ajaxRs",data: {"id": ids}});
                    }
                }
            });
        } else {
            layer.msg(arrLang[lang]["publicSystemException"], {icon: 2, time: 1000});
        }
    }else {
        layer.msg(arrLang[lang]["publicPleaseSelectDataFirst"], {icon: 2, time: 1000});
    }
}

/*
 批量下载 API[批量处理]
 */
function downloadBatchApi(obj) {
    var ids = new Array();
    $("input[name='check_id']:checked").each(function () {
        ids.push(this.value);
    });
    ids = ids.join(',');
    if (ids) {
        var data_class = $(obj).attr("data-class");
        data_class = typeof (data_class) === "undefined" ? "" : data_class
        if(data_class){
            var href=$("."+data_class).attr("data-href");
            $("."+data_class).attr("href",href+ids);
            $("#"+data_class).click();
        }
    }else {
        layer.msg(arrLang[lang]["publicPleaseSelectDataFirst"], {icon: 2, time: 1000});
    }
}

/*导出操作*/
function excelReportdo(obj) {
    layer.confirm(arrLang[lang]["publicAskSureExec"], {
        btn: [arrLang[lang]["confirm"], arrLang[lang]["cancel"]],
        title: arrLang[lang]["message"]
    }, function (index, layero) {
        layer.msg(arrLang[lang]["publicAlreadyExecOp"], {icon: 1, time: 1000});
        var url = $(obj).attr("_href");
        if (url) {
            window.open(url + "?" + $(obj).parents("form").serialize());
        }
    }, function (index) {

    });
}

