
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for `ad_manage`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}ad_manage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告ID',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '广告名称',
  `type` tinyint(1) NOT NULL COMMENT '广告类型 1:img 2:文字 3:code',
  `positionId` int(11) NOT NULL COMMENT '广告位ID',
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '链接地址',
  `sortWeights` smallint(6) NOT NULL DEFAULT '0' COMMENT '排列顺序权重,越小越靠前',
  `startTime` int(11) NOT NULL DEFAULT '0' COMMENT '开始时间时间戳',
  `endTime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间时间戳',
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '图片url、文字，code等',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `position_id` (`positionId`) USING BTREE,
  KEY `order` (`sortWeights`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告管理';

-- ----------------------------
-- Table structure for `ad_position`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}ad_position` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告位ID',
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '广告位名称',
  `width` smallint(6) NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(6) NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `fashion` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:轮显,2:随即',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:开启,2: 关闭',
  `index` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '广告索引',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index` (`index`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告位置管理';

-- ----------------------------
-- Table structure for `module`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '类型',
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `urlPath` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'url路径',
  `domain_pc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '域名',
  `linkUrl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '链接地址',
  `style` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '样式',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `isLink` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否是链接',
  `isMenu` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否是菜单',
  `isBlank` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否新窗口打开',
  `logo` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否独立logo',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否开启：0 禁用，1 开启',
  `installTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `createTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updateTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `domain_mobile` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '手机端绑定域名',
  `plugins` char(32) NOT NULL COMMENT '插件标识',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `plugins` (`plugins`) USING BTREE,
  KEY `name` (`name`) USING BTREE,
  KEY `module` (`module`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模型' AUTO_INCREMENT=10;

-- ----------------------------
-- Table structure for `map_relation`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}map_relation` (
  `fromId` int(10) unsigned NOT NULL DEFAULT '0',
  `toId` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '菜单id',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '类型',
  UNIQUE KEY `moduleId_navId_type` (`fromId`,`toId`,`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `cache`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}cache` (
  `cacheid` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '唯一键',
  `expireTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '过期时间',
  UNIQUE KEY `cacheid` (`cacheid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `friend_link`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}friend_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `groupId` tinyint(4) NOT NULL DEFAULT '1' COMMENT '分组id 目前没有',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态 0 隐藏 1显示',
  `linkName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '链接名称',
  `linkUrl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '链接地址',
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '描述',
  `className` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '样式class',
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'LOGO链接地址',
  `sortWeights` int(11) NOT NULL DEFAULT '1' COMMENT '排序权重,越小越靠前',
  `addTime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `sortWeights` (`sortWeights`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='友情链接';

-- ----------------------------
-- Table structure for `member_admin`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}member_admin` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户唯一标识',
  `password` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '密码',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态 1启用,2禁用',
  `roleId` int(11) DEFAULT '0' COMMENT '管理员角色',
  `isAdmin` tinyint(1) NOT NULL DEFAULT '0' COMMENT '超级管理员：1 是，0 否',
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `guid` (`user`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员';

-- ----------------------------
-- Table structure for `friend_link_group`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}friend_link_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '上级id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分组名称',
  `className` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '网页样式',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='友链分组';

-- ----------------------------
-- Table structure for `single_page_group`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}single_page_group` (
  `id` varchar(191) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `name` varchar(191) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='单页分组管理';

-- ----------------------------
-- Table structure for `member_admin_func`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}member_admin_func` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menuId` int(11) NOT NULL DEFAULT '0' COMMENT '菜单id',
  `routhAction` tinyint(4) NOT NULL DEFAULT '1' COMMENT '请求方法 1get 2post 3put 4delete',
  `route` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '路由地址',
  `module` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '控制器 命名空间',
  `moduleName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '控制器名称',
  `action` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '方法   ',
  `actionName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '方法名称',
  `other` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '控制器,方法相同,增加额外参数',
  `isShow` tinyint(4) NOT NULL DEFAULT '1' COMMENT '节点显示到左侧,节点可以点击跳页面  导航->菜单->节点     1节点方法 2非节点方法,  ',
  `isEnable` tinyint(4) NOT NULL DEFAULT '1' COMMENT '是否启用',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序权重',
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  `plugins` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '来源  插件唯一信息  方便卸载统一删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pid` (`menuId`) USING BTREE,
  KEY `action_module` (`action`,`module`) USING BTREE,
  KEY `actionName` (`actionName`) USING BTREE,
  KEY `moduleName` (`moduleName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='管理员功能权限表';

-- ----------------------------
-- Table structure for `member_admin_menu`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}member_admin_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '上级id 0为顶级',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `icon` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1显示 2 不显示',
  `plugin` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '来源插件,方便卸载统一删除',
  `isTop` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '置顶：>=1 是，0 否',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理员后台导航菜单表';

-- ----------------------------
-- Table structure for `member_admin_role`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}member_admin_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '角色名',
  `description` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1可用,2禁用,已赋予角色用户停用所有权限,禁止新赋予该角色',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色表';

-- ----------------------------
-- Table structure for `member_admin_role_func`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}member_admin_role_func` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `roleId` int(11) NOT NULL DEFAULT '0' COMMENT '角色id',
  `funcId` int(11) NOT NULL DEFAULT '0' COMMENT '功能权限id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `roleId_funcId` (`roleId`,`funcId`) USING BTREE,
  KEY `roleId` (`roleId`) USING BTREE,
  KEY `menuId` (`funcId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='角色和权限功能关系表';

-- ----------------------------
-- Table structure for `sessions`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}sessions` (
  `sid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'session_id',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'session数据',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '过期时间',
  PRIMARY KEY (`sid`) USING BTREE,
  UNIQUE KEY `sid` (`sid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `setting`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}setting` (
  `itemKey` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'key 唯一自动索引  ',
  `itemValue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '设置值',
  `pid` varchar(30) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '父id, 1=系统设置,2=SEO设置,3=性能优化 4=云服务  5=成员基础设置其他待定',
  UNIQUE KEY `itemKey_pid` (`itemKey`,`pid`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `single_page`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}single_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分组名称',
  `level` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '等级',
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '标题',
  `style` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '样式',
  `seoTitle` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seoKeywords` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seoDescription` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `updateTime` int(11) NOT NULL DEFAULT '0' COMMENT '最后编辑时间',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '点击计数',
  `isLink` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否为外部链接',
  `linkUrl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '外部链接或文件相对路径+文件名',
  `domain` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主页',
  `template` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板名称,默认模板为空',
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '富内容',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE,
  KEY `title` (`title`) USING BTREE,
  KEY `level` (`level`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='单页管理';

-- ----------------------------
-- Table structure for `category`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '名称',
  `createTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updateTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态：1 启用，0 禁用',
  `fieldIndex` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '索引',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '缩略图',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级分类',
  `dataId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '数据id',
  `dataType` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '数据类型',
  `catDir` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类目录',
  `seo_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'seo 标题',
  `seo_keywords` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'seo 关键词',
  `seo_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'seo 描述',
  `child_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类数量',
  `parent_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级分类数量',
  `linkurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '链接地址',
  `style` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '样式：颜色',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '级别：0 - 不在首页显示 1 - 正常显示 2 - 首页和上级分类并列显示',
  `item` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '信息量',
  `template_list` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `template_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `dataType_dataId_name_pid` (`dataType`,`dataId`,`name`,`pid`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `commend_module_data`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}commend_module_data` (
  `commendId` smallint(5) unsigned NOT NULL COMMENT '推荐类型ID',
  `dataId` int(10) unsigned NOT NULL COMMENT '数据id',
  `moduleId` int(11) NOT NULL COMMENT '模型id',
  `createTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  UNIQUE KEY `dataId_moduleId_commendId` (`dataId`,`moduleId`,`commendId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='推荐类商品';

-- ----------------------------
-- Table structure for `category_child`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}category_child` (
  `dataType` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据类型',
  `parentId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '父级id',
  `childId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '子级id',
  UNIQUE KEY `dataType_id_childId` (`dataType`,`parentId`,`childId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `category_data`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}category_data` (
  `dataType` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据类型',
  `parentId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '父级id',
  `childId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '子级id',
  `dataId` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '数据id',
  UNIQUE KEY `dataType_id_childId` (`dataType`,`parentId`,`childId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `category_op`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}category_op` (
  `dataType` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据类型',
  UNIQUE KEY `dataType` (`dataType`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for `software_upgrade_log`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}software_upgrade_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `createTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updateTime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `version` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '版本号',
  `version_nums` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '版本号转成数字',
  `stage` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '项目阶段',
  `packageUrl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '包地址',
  `packageSize` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '包大小',
  `project` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '项目',
  `version_complete` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '完整版本',
  `date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '日期',
  `result` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '结果：1 成功 ，2 失败，0 未处理',
  `oldFile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备份内容',
  `updateFile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '更新内容',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `project_stage` (`project`,`stage`) USING BTREE,
  KEY `version` (`version`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='软件升级log';

-- ----------------------------
-- Table structure for `fields`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `table_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '表名',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段',
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `note` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '提示信息',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段属性',
  `length` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '字段长度',
  `html` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '表单类型',
  `default_value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '默认值',
  `option_value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '选项卡值',
  `width` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '[图片上传]宽度',
  `height` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '[图片上传]高度',
  `input_limit` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '输入限制',
  `addition` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '附加内容',
  `backend_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '直接显示',
  `use_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '前台显示',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `tablename` (`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自定义字段';

-- ----------------------------
-- Table structure for `log_operation`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}log_operation` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `author` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '操作人员',
  `action` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '动作',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '内容',
  `create_time` bigint(20) NOT NULL DEFAULT '0' COMMENT '时间',
  `ip_address` varchar(20) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日志操作记录';

SET FOREIGN_KEY_CHECKS = 1;

