<?php

namespace ltcms\utils;

class Str
{
    public static $camelCache=array();
    public static $studlyCache=array();

    /**
     * 下划线转驼峰(首字母小写)
     *
     * @param  string $value
     * @return string
     */
    public static function camel($value): string
    {
        if (isset(static::$camelCache[$value])) {
            return static::$camelCache[$value];
        }
        return static::$camelCache[$value] = lcfirst(static::studly($value));
    }

    /**
     * 下划线转驼峰(首字母大写)
     *
     * @param  string $value
     * @return string
     */
    public static function studly(string $value): string
    {
        $key = $value;
        if (isset(static::$studlyCache[$key])) {
            return static::$studlyCache[$key];
        }
        $value = ucwords(str_replace(['-', '_'], ' ', $value));
        return static::$studlyCache[$key] = str_replace(' ', '', $value);
    }


    /**
     * 获取数据类型
     * @param $value
     */
    public static function getType($value,$op=1)
    {
        $type=false;
        if($op=="1"){
            if(is_array($value)){
                $type="arr";
            }elseif (is_string($value)){
                $type="str";
            }elseif(is_int($value)){
                $type="int";
            }elseif(is_double($value)){
                $type="float";
            }elseif(is_object($value)){
                $type="object";
            }else{
                $type="str";
            }
        }else if($op=="2"){
            if(is_string($value)){
                $type="s";
            }elseif (is_int($value)){
                $type="i";
            }elseif (is_double($value)){
                $type="d";
            }else{
                $type="s";
            }
        }
        return $type;
    }


}