<?php
namespace ltcms\response;

/**
 * Redirect Response
 */
class Redirect extends Response
{

    protected $request;

    public function __construct($data = '', int $code = 302)
    {
        $this->init((string) $data, $code);

        $this->cacheControl('no-cache,must-revalidate');
    }

    /**
     * 处理数据
     * @param mixed $data
     * @param $templatePath
     * @access protected
     * @return string
     */
    protected function output($data, $templatePath): string
    {
        $this->header['Location'] = $data;

        return '';
    }
}
