<?php

namespace ltcms\lib;

class Page
{
    public  $index;//当前页

    public  $totalPage;//总页数
    public  $firstPage;//第一页
    public  $lastPage;//最后一页
    public  $pageLength=10;//要展示的页面数

    public  $total;//总页数
    public  $pageSize;//每页的条数
    public  $page;//当前请求页数

    /**
     * 获取传递的参数
     */
    public function getParam($listRows){
        $defaultConfig = [
            'varPage'  =>config("database.varPage")?:"page", //分页变量
            'pageSize'  =>config("database.pageSize")?:"20", //分页数
        ];
        if (is_array($listRows)) {
            $config   = array_merge($defaultConfig, $listRows);
            $pageSize = intval($config['pageSize']);
        } else {
            $config   = $defaultConfig;
            $pageSize = intval($listRows ?: $config['pageSize']);
        }
        $page = isset($config['page']) ? (int) $config['page'] : request()->param($config['varPage']."/d");
        $page = $page < 1 ? 1 : $page;
        $this->pageSize=$pageSize;
        $this->page=$page;
    }

    /**
     * 查询数据
     * @param $sql
     * @param $listRows
     */
    public function query($totalSql,$sql,$listRows,$connect)
    {
        $this->getParam($listRows);
        $result=Db()->changeConnect($connect)->query($totalSql);
        if($result)
        {
            $this->total=isset($result[0]['total']) ? $result[0]['total'] : 0;
        }
        else
        {
            $this->total=0;
        }
        if($this->total > 0){
            $this->totalPage=floor(($this->total-1)/$this->pageSize)+1;

            $this->index=$this->page;
            if($this->index>$this->totalPage)
            {
                $this->index=$this->totalPage;
            }

            $this->firstPage=$this->index-floor($this->pageLength/2);
            if($this->firstPage<=0)
            {
                $this->firstPage=1;
            }

            $this->lastPage=$this->firstPage + $this->pageLength-1;
            if($this->lastPage > $this->totalPage)
            {
                $this->lastPage=$this->totalPage;
                $this->firstPage=($this->totalPage-$this->pageLength) >0?$this->totalPage-$this->pageLength+1:1;
            }
            $offset=isset($listRows["nums"])?$listRows["nums"]:0;
            if($offset){
                if(strpos($sql,"%LIMIT%")!==false){
                    $sql= trim(str_replace(
                        ['%LIMIT%'],
                        [
                            "limit {$offset},{$this->pageSize}",
                        ],$sql));
                }else{
                    $sql= $sql."limit {$offset},{$this->pageSize}";
                }
            }else{
                if(strpos($sql,"%LIMIT%")!==false){
                    $sql= trim(str_replace(
                        ['%LIMIT%'],
                        [
                            $this->parseLimit($this->index,$this->pageSize),
                        ],$sql));
                }else{
                    $sql= $sql." ".$this->parseLimit($this->index,$this->pageSize);
                }
            }
            $result=Db()->changeConnect($connect)->query($sql);
            $data=array();
            $data["page"]=$this->index;
            $data["total"]=$this->total;
            $data["totalPage"]=$this->totalPage;
            $data["lastPage"]=$this->lastPage;
            $data["firstPage"]=$this->firstPage;
            $data["data"]=$result;
            return $data;
        }
        return array();
    }

    /**
     * 查询数据
     * @param $sql
     * @param $listRows
     */
    public function stmtQuery($totalSql,$sql,$parsePrepareData,$listRows,$connect)
    {
        $this->getParam($listRows);
        $result=Db()->changeConnect($connect)->stmtQuery($totalSql,$parsePrepareData,1);
        if($result)
        {
            $this->total=isset($result[0]['total']) ? $result[0]['total'] : 0;
        }
        else
        {
            $this->total=0;
        }
        if($this->total > 0){
            $this->totalPage=floor(($this->total-1)/$this->pageSize)+1;

            $this->index=$this->page;
            if($this->index>$this->totalPage)
            {
                $this->index=$this->totalPage;
            }

            $this->firstPage=$this->index-floor($this->pageLength/2);
            if($this->firstPage<=0)
            {
                $this->firstPage=1;
            }

            $this->lastPage=$this->firstPage + $this->pageLength-1;
            if($this->lastPage > $this->totalPage)
            {
                $this->lastPage=$this->totalPage;
                $this->firstPage=($this->totalPage-$this->pageLength) >0?$this->totalPage-$this->pageLength+1:1;
            }

            if(strpos($sql,"%LIMIT%")!==false){
                $sql= trim(str_replace(
                    ['%LIMIT%'],
                    [
                        $this->parseLimit($this->index,$this->pageSize),
                    ],$sql));
            }else{
                $sql= $sql." ".$this->parseLimit($this->index,$this->pageSize);
            }

            $result=Db()->changeConnect($connect)->stmtQuery($sql,$parsePrepareData,1);
            $data=array();
            $data["page"]=$this->index;
            $data["total"]=$this->total;
            $data["totalPage"]=$this->totalPage;
            $data["lastPage"]=$this->lastPage;
            $data["firstPage"]=$this->firstPage;
            $data["data"]=$result;
            return $data;
        }
        return array();
    }

    /**
     * 解析条数
     * @return string
     */
    public function parseLimit($page,$pageSize){
        $offset=($page - 1) * $pageSize;
        return "limit {$offset},{$pageSize}";
    }

    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBar($data)
    {
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<li><a href="'.$href.'"><span>'.lang("page.home").'</span></a></li>';

        $href = $baseUrl.($data["page"]-1);
        if($data["firstPage"]>1){
            $tem.='<li><a href="'.$href.'"><span class="prev" >'.lang("page.leftBtn").'</span></a></li>';
        }

        for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li class="active" ><a href="'.$href.'"><span>'.$i.'</span></a></li>';
            }else{
                $tem.='<li><a href="'.$href.'"><span>'.$i.'</span></a></li>';
            }
        }

        $href = $baseUrl.($data["page"]+1);
        if($data["lastPage"] < $data["totalPage"]){
            $tem.='<li><a href="'.$href.'"><span class="next" >'.lang("page.rightBtn").'</span></a></li>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<li><a href="'.$href.'"><span>'.lang("page.end").'</span></a></li>';

        $tem.='<li><span>'.lang("page.trips",array("index"=>$data["page"],"totalPage"=>$data["totalPage"],"total"=>$data["total"])).'</span></li>';
        return $tem;
    }

    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBarV2($data)
    {
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<a href="'.$href.'"><span>'.lang("page.home").'</span></a>';

        $href = $baseUrl.($data["page"]-1);
        if($data["firstPage"]>1){
            $tem.='<a href="'.$href.'"><span class="prev" >'.lang("page.leftBtn").'</span></a>';
        }

        $tem.='<ul>';
        for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li><a class="active"  href="'.$href.'"><span>'.$i.'</span></a></li>';
            }else{
                $tem.='<li><a href="'.$href.'"><span>'.$i.'</span></a></li>';
            }
        }
        $tem.='</ul>';

        $href = $baseUrl.($data["page"]+1);
        if($data["lastPage"] < $data["totalPage"]){
            $tem.='<a href="'.$href.'"><span>'.lang("page.rightBtn").'</span></a>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';
        return $tem;
    }

}