<?php

namespace ltcms\lib;

/**
 * 语言类
 */
class Lang
{
    private static $_instance;
    protected $lang=array();
    protected $pluginLang=array();

    private function __construct(){}
    private function __clone(){ }

    /**
     * 初始化配置
     */
    public function loader(){
        //遍历配置目录
        $default=config("app.language")?:"zh-cn";
        $langDirs=array(
            LTCMS_PATH."/lang",
            LTCMS_APP."/lang",
        );
        if(defined("LTCMS_APP_NAME")){
            $langDirs[]=LTCMS_APP."/".LTCMS_APP_NAME."/lang";
        }
        $langDirs[]=LTCMS_CUSTOM."/lang";
        foreach($langDirs as $dir){
            if(is_dir($dir)){
                $funcs=glob($dir."/*.php");
                if($funcs && is_array($funcs)){
                    foreach($funcs as $file){
                        $fileName=strtolower(basename($file,".php"));
                        if($fileName==$default){
                            $tmp=@include $file;
                            if(is_array($tmp)){
                                if($this->lang){
                                    $this->lang=arrFusion($this->lang,$tmp);
                                }else{
                                    $this->lang=$tmp;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载语言包
     */
    public function pluginLoader($dir,$pre=""){
        //遍历配置目录
        $default=config("app.language")?:"zh-cn";
        if($dir && is_dir($dir)){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    $fileName=strtolower(basename($file,".php"));
                    if($fileName==$default){
                        $tmp=@include $file;
                        if(is_array($tmp) && $tmp){
                            //添加前缀-$tmp
                            if(!$pre){
                                $dirs=explode("/",str_replace(LTCMS_ROOT."/","",$dir));
                                if(isset($dirs["1"])){
                                    $pre=$dirs["1"];
                                }
                            }
                            if(isset($this->pluginLang[$pre])){
                                $this->pluginLang[$pre]=arrFusion($this->pluginLang[$pre],$tmp);
                            }else{
                                $this->pluginLang[$pre]=$tmp;
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 设置
     * @param $name
     * @param $value
     */
    public function __set($name, $value)
    {

    }

    /**
     * 获取数据
     * @param $name
     * @param null $params
     * @return mixed
     */
    public function get($name,$params=null){
        $data=getData($this->lang,$name);
        if($params && is_array($params)){
            $find=array();
            $replace=array();
            foreach($params as $key=>$val){
                $find[]="{:".$key."}";
                $replace[]=$val;
            }
            $data= str_replace($find,$replace,$data);
        }
        return $data;
    }

    /**
     * 获取数据
     * @param $name
     * @param null $params
     * @return mixed
     */
    public function getPlugin($name,$params=null){
        $data=getData($this->pluginLang,$name);
        if($params && is_array($params)){
            $find=array();
            $replace=array();
            foreach($params as $key=>$val){
                $find[]="{:".$key."}";
                $replace[]=$val;
            }
            $data= str_replace($find,$replace,$data);
        }
        return $data;
    }
}