<?php

namespace ltcms\lib;

/**
 * 配置类
 */
class Config
{
    private static $_instance;
    protected $config=array();
    protected $pluginConfig=array();

    private function __construct(){}
    private function __clone(){ }

    /**
     * 初始化配置
     */
    public function loader(){
        //遍历配置目录
        $configDirs=array(
            LTCMS_PATH."/config",
            LTCMS_APP."/config",
        );
        if(defined("LTCMS_APP_NAME")){
            $configDirs[]=LTCMS_APP."/".LTCMS_APP_NAME."/config";
        }
        $configDirs[]=LTCMS_CUSTOM."/config";
        foreach($configDirs as $dir){
            if(is_dir($dir)){
                $funcs=glob($dir."/*.php");
                if($funcs && is_array($funcs)){
                    foreach($funcs as $file){
                        $fileName=strtolower(basename($file,".php"));
                        $tmp=@include $file;
                        if(is_array($tmp)){
                            if(isset($this->config[$fileName])){
                                $this->config[$fileName]=arrFusion($this->config[$fileName],$tmp);
                            }else{
                                $this->config[$fileName]=$tmp;
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载配置
     */
    public function pluginLoader($dir,$pre=""){
        //遍历配置目录
        if(is_dir($dir)){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    if(!$pre){
                        $dirs=explode("/",str_replace(LTCMS_ROOT."/","",$dir));
                        if(isset($dirs["1"])){
                            $pre=$dirs["1"];
                        }
                    }
                    $fileName=strtolower(basename($file,".php"));
                    $tmp=@include $file;
                    if(is_array($tmp) && $tmp){
                        if(isset($this->pluginConfig[$pre][$fileName])){
                            $this->pluginConfig[$pre][$fileName]=arrFusion($this->pluginConfig[$fileName],$tmp);
                        }else{
                            $this->pluginConfig[$pre][$fileName]=$tmp;
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载配置-覆盖
     */
    public function pluginLoaderCover($dir){
        //遍历配置目录
        if(is_dir($dir)){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    $fileName=strtolower(basename($file,".php"));
                    $tmp=@include $file;
                    if(is_array($tmp) && $tmp){
                        if(isset($this->config[$fileName])){
                            $this->config[$fileName]=arrFusion($this->config[$fileName],$tmp);
                        }else{
                            $this->config[$fileName]=$tmp;
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载文件
     */
    public function pluginLoaderFile($fileList=array()){
        //遍历配置目录
        if($fileList){
            foreach($fileList as $file){
                if(is_file($file)){
                    $fileName=strtolower(basename($file,".php"));
                    $tmp=@include $file;
                    if(is_array($tmp)){
                        if(isset($this->pluginConfig[$fileName])){
                            $this->pluginConfig[$fileName]=arrFusion($this->pluginConfig[$fileName],$tmp);
                        }else{
                            $this->pluginConfig[$fileName]=$tmp;
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 设置配置
     * @param $name
     * @param $value
     */
    public function set($name, $value)
    {
        $this->config=setData($name,$value,$this->config);
    }

    /**
     * 获取配置
     * @param $name
     * @return mixed
     */
    public function get($name)
    {
        return getData($this->config,$name);
    }

    /**
     * 设置配置
     * @param $name
     * @param $value
     */
    public function setPlugin($name, $value)
    {
        $this->pluginConfig=setData($name,$value,$this->pluginConfig);
    }

    /**
     * 获取配置
     * @param $name
     * @return mixed
     */
    public function getPlugin($name)
    {
        return getData($this->pluginConfig,$name);
    }
}