<?php

namespace ltcms\container;

/**
 * 容器类
 */
class Container extends ContainerBase
{
    /**
     * 设置容器
     * @param $name
     * @param $value
     */
    public function __set($name, $value)
    {
        $this->elements[$name] = $value;
    }

    /**
     * 获取容器
     * @param $name
     * @return bool
     */
    public function __get($name)
    {
        if (isset($this->elements[$name])) {
            return $this->elements[$name];
        }
        return null;
    }

    /**
     * 检测是否存在
     * @param $name
     * @return bool
     */
    function __isset($name)
    {
        return isset($this->elements[$name]);
    }

    /**
     * 删除容器
     * @param $name
     */
    function __unset($name)
    {
        if($this->__isset($name)){
            unset($this->elements[$name]);
        }
    }
}