<?php

namespace ltcms\cache;

class Cache implements Cache_contract
{
    protected $resource;
    protected $driver = LTCMS_CACHE_DRIVER?LTCMS_CACHE_DRIVER:"file";
    private static $_instance;

    private function __construct(){
        $this->_init();
    }
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 初始化对象
     */
    public function _init()
    {
        if(!isset($this->resource[$this->driver])){
            if($this->driver=="file"){
                include_once __DIR__."/Cache_file.php";
                $cacheFile=new Cache_file();
                $cacheFile->setConfig();
                $this->resource[$this->driver]=$cacheFile;
            }else{
                throw new \Exception("cache:{$this->driver} 驱动不存在");
            }
        }
    }

    /**
     * 切换驱动
     */
    public function changeDriver($driver){
        $this->driver=$driver;
        return $this;
    }

    /**
     *  获取缓存
     */
    public function get($key)
    {
        return  $this->resource[$this->driver]->get($key);
    }

    /**
     *  设置缓存
     */
    public function set($key, $val, $ttl=null)
    {
        $this->resource[$this->driver]->set($key, $val, $ttl);
    }

    /**
     *  删除缓存
     */
    public function rm($key)
    {
        $this->resource[$this->driver]->rm($key);
    }

    /**
     *  清除缓存
     */
    public function clear()
    {
        $this->resource[$this->driver]->clear();
    }

    /**
     *  删除过期缓存
     */
    public function expire()
    {
        $this->resource[$this->driver]->expire();
    }
}

