<?php

namespace ltcms;

use ltcms\lib\Helper;

/**
 * 自动加载函数
 * Class Loader
 */
class Loader
{
    private static $_instance;

    private function __construct(){}
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 注册加载函数
     */
    public function register(){
        spl_autoload_extensions('.php');
        spl_autoload_register(array($this, 'loader'));
    }

    /**
     * 加载文件
     * Loader constructor.
     * @param $className
     */
    public function loader($className){
        $classPath=LTCMS_ROOT."/".str_replace("\\", '/', $className).".php";
        if(!is_file($classPath)){
            $register=config("register",array());
            if($register){
                $classNameMap=explode("\\",$className);
                $firstName=strtolower(array_shift($classNameMap));
                if(isset($register[$firstName]) && $register[$firstName]){
                    $className=implode("\\",$classNameMap);
                    $classPath=LTCMS_ROOT."/".$register[$firstName]."/".$className.".php";
                    $classPath=str_replace("\\", '/', $classPath);
                }
            }
        }
        if(file_exists($classPath)){
            @include_once $classPath;
        }
    }

    /**
     * 注销加载函数
     * @param $className
     * @param $fucntionName
     */
    public function unregister($className,$fucntionName){
        spl_autoload_unregister(array($className,$fucntionName));
    }

    /**
     * 获取注册的方法
     * @return array
     */
    public function getFunctions(){
        return spl_autoload_functions();
    }

    /**
     * 注册扩展名
     * @return array
     */
    public function registerExtensions($file_extensions =null){
        return $file_extensions?spl_autoload_extensions ($file_extensions):spl_autoload_extensions();
    }

    /**
     * 注册公共函数
     */
    public function registerFunc(){
        Helper::loader();
    }
}

$loader=Loader::getInstance();
$loader->register();
$loader->registerFunc();


