<?php

$today=date("Y-m-d");  //当天日期
$sitemaps_module=extendSetting("sitemaps_module"); //所选模块
if(!$sitemaps_module) {
    return false;
}
$sitemaps_changefreq=extendSetting("sitemaps_changefreq"); //更新内容-频率
$sitemaps_priority=extendSetting("sitemaps_priority"); //更新内容-优先级
$sitemaps_items=extendSetting("sitemaps_items"); //生成数量
$url=config("app.url");

//记录首页
$sitemaps=array();
$sitemaps[]=array(
    "loc"=>$url,
    "changefreq"=>"always",
    "priority"=>"1",
    "lastmod"=>$today,
);

$limit=intval($sitemaps_items/count(explode(",",$sitemaps_module)));
$paramsObj=paramsObj();
$paramsObj->params=array(
    "id"=>$sitemaps_module,
);
$checkResult = app("S_Index_module")->allData($paramsObj);
if($checkResult["error_no"]==0){
    $moduleResult=$checkResult["result"];
    if($moduleResult){
        foreach($moduleResult as $module){
            //记录模块信息
            $sitemaps[]=array(
                "loc"=>$module['linkUrl'],
                "changefreq"=>"hourly",
                "priority"=>"0.9",
                "lastmod"=>$today,
            );
            //更新文章模块
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "moduleId"=>$module["id"],
                "limit"=>$limit,
                "field"=>"id,addTime,linkUrl,updateTime",
            );
            $checkResult=app("S_Api_article")->validData($paramsObj);
            if($checkResult["error_no"]=="0"){
                $articleResult=$checkResult["result"];
                foreach($articleResult as $article){
                    $sitemaps[]=array(
                        "loc"=>$module['linkUrl'].$article['linkUrl'],
                        "changefreq"=>$sitemaps_changefreq,
                        "priority"=>$sitemaps_priority,
                        "lastmod"=>date("Y-m-d",$article['addTime']),
                    );
                }
            }else{
                return false;
            }
        }
    }else{
        return false;
    }
}

//生成站点地图
$paramsObj=paramsObj();
$paramsObj->params=array(
    "data"=>$sitemaps,
);
$checkResult=app("P_sitemaps")->store($paramsObj);
if($checkResult["error_no"]){
   return false;
}

return true;
?>

