<?php

namespace app\utils\base\plugin\tags;

class Tag_plugin_agent implements Tag_plugin_contract
{
    /**
     *  调用标签
     */
    public function run($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'tagName' => 'require',
                'extraData' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr['error_no'] == 0) {
            //获取注册绑定信息
            $tag=config("plugin.tag");
            if(isset($tag[$dataObj->request->tagName])){
                list($class,$method)=array_pad(explode("|",$tag[$dataObj->request->tagName]),2,"");
                $class=str_replace("/","\\",$class);
                if(class_exists($class)){
                    $obj=new $class();
                    if(method_exists($obj,$method)){
                        $paramObj = paramsObj();
                        $paramObj->params = array(
                            "extraData" => $dataObj->request->extraData,
                        );
                        $checkResult=$obj->$method($paramObj);
                        if ($checkResult["error_no"] == 0) {
                            $final_arr["result"] = $checkResult["result"];
                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::NOT_IMPLEMENTED, lang("sys.noMethodDefined"));
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::NOT_IMPLEMENTED, lang("sys.noMethodDefined"));
                }
            }else{
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::NOT_IMPLEMENTED, lang("sys.noMethodDefined"));
            }
//            //  类名_类名类名xxx_方法     //_符号最后一个是方法
//            $className = $dataObj->request->tagName;
//            $action = "run";
//            $lastUnderscorePos = strrpos($className, "_");
//
//            if ($lastUnderscorePos !== false) {
//                $className = substr($dataObj->request->tagName, 0, $lastUnderscorePos);
//                if (substr($dataObj->request->tagName, $lastUnderscorePos + 1)) {
//                    $action = substr($dataObj->request->tagName, $lastUnderscorePos + 1);
//                }
//            }
//            $pluginClassName = 'Tag_' . $className . '_plugin'; //;临时处理,后续在改
//            if (class_exists($pluginClassName)) {
//                $plugin_obj = new $pluginClassName();
//                $paramObj = paramsObj();
//                $paramObj->params = array(
//                    "extraData" => $dataObj->request->extraData,
//                );
//                $checkResult = $plugin_obj->$action($paramObj);//运行插件调用方法获取数据
//                if ($checkResult["error_no"] == 0) {
//                    $final_arr["result"] = $checkResult["result"];
//                } else {
//                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
//                }
//            } else {
//                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::NOT_IMPLEMENTED, lang("sys.noMethodDefined"));
//            }
        }
        return $final_arr;
    }

    /**
     *  过滤标签参数
     */
    public function filterParams($params,$extra=array())
    {
        $sysParam = array();
        $conditionMap = array();
        if ($params) {
            $extraData = trim($params);
            $extraData = array_filter(explode(" ", $extraData));
            if ($extraData) {
                foreach ($extraData as $zval) {
                    if ($zval) {
                        list($filed, $val) = explode("=", $zval);
                        $val = trim($val, " '\"");
                        $filed = trim($filed);

                        if (in_array($filed, array("key", "receiveName", "val", "noneStr"))) {
                            $sysParam[$filed] = $val;
                        } else {
                            $conditionMap[$filed] = $val;
                        }
                    }
                }
            }
        }
        $return = array();
        $return["condition"] = array_merge($conditionMap,$extra);
        $return["sysParam"] = $sysParam;
        return $return;
    }

    /**
     *  解析condition条件
     */
    public function parseCondition($condition)
    {
        $result = array();
        $condition = is_array($condition) ? $condition : toJsonDecode($condition);
        if ($condition) {
            foreach ($condition as $key => $val) {
                if ($key == "limit") {
                    if (strpos($val, ",") === false) {
                        $result["offset"] = $val;
                    } else {
                        list($offset, $limit) = explode(",", $val);
                        $result["offset"] = $offset;
                        $result["limit"] = $limit;
                    }
                } else {
                    $result[$key] = $val;
                }
            }
        }
        return $result;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}

?>