<?php

namespace app\utils\base\plugin\tags;

class Tag_news_plugin
{
    /**
     * 获取新闻数据
     */
    public function getList($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $params=array();
            $params=array_merge($params,$condition);
            $size=getVal($params,"size",4);
            $url=config("app.cmsUrl")."/api/cmssite/article?moduleId=12&pageSize={$size}&field=webTitle,linkUrl,id";
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "submitUrl"=>$url,
                "method"=>"get",
                "time"=>10,
            );
            $checkResult=app("P_http")->send($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                if($result["httpCode"]=="200"){
                    $body=$result["body"];
                    $body=toJsonDecode($body);
                    if($body){
                        if($body["success"]){
                            $return=array();
                            $return["result"]=$body["data"];
                            $final_arr["result"]=$return;
                        }else{
                            $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"),$body["codeMsg"]);
                        }
                    }else{
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
                    }
                }else{
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"),$result["error_msg"]);
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}

?>