<?php

namespace app\utils\base\plugin\tags;

class Tag_article_plugin
{
    /**
     * 获取文件推荐信息
     */
    public function getRecommend($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->getRecommend($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 文章列表
     */
    public function getList($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->params=array();
            $paramsObj->mixed=1;
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->getList($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $result["render"]="paging";
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 文章单条数据
     */
    public function getRowData($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->info($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $result["row"]=1;
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 相关推荐列表
     */
    public function correlationRecommend($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("L_Index_article")->getCorrelationList($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 随机数据
     */
    public function randData($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->randData($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取上一篇
     */
    public function pre($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->pre($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取下一篇
     */
    public function next($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->next($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取文章数据
     */
    public function articleData($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->articleData($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取-标签-文章数据
     */
    public function tagArticleData($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj->params=array();
            if($condition && is_array($condition)){
                $paramsObj->params=array_merge($paramsObj->params,$condition);
            }
            $checkResult = app("S_Index_article")->tagData($paramsObj);
            if($checkResult["error_no"]==0){
                $result=array();
                $result["result"]=$checkResult["result"];
                $final_arr["result"]=$result;
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}

?>