<?php

namespace app\utils\base\plugin\oauth;

class Oauth_ltcms_plugin extends Oauth_ltcms_base_plugin
{
	//第三方登录名称
	public $name = 'Ltcms-账号密码登录';

	/**
	 * 获取登录URL
	 * @return string
	 */
	public function getLoginUrl($paramObj="")
	{
		$dataObj=paramsObj();
		$dataObj->request=paramsObj();
		$dataObj->data=paramsObj();

		$final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
		if($final_arr["error_no"]==0)
		{
			$extraData=is_array($dataObj->request->extraData)?$dataObj->request->extraData:toJsonDecode($dataObj->request->extraData);
			$state=array(
				"scope"=>isset($extraData["scope"])?$extraData["scope"]:"snsapi_userinfo",
				"redirect_uri"=>isset($extraData["redirect_uri"])?$extraData["redirect_uri"]:"",
			);
			$params=array();
			$params["response_type"]="code";
			$params["appid"]=$this->appId;
			$params["redirect_uri"]=config("app.url").LTCMS_ROUTE_PREFIX."/users/callback";
			$params["scope"]=$state["scope"];//权限作用域
			$params["state"]=arrToUrlPrarm($state,false);
			$url=$this->baseUrl."/oauth/authorize?".http_build_query($params);
			$return=array(
				"loginUrl"=>$url,
			);
			$final_arr["result"]=$return;
		}
		return $final_arr;
	}

	/**
	 * 回调
	 * @return string
	 */
	public function callback($paramObj="")
	{
		$dataObj=paramsObj();
		$dataObj->request=paramsObj();
		$dataObj->data=paramsObj();

		$final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
		if($final_arr["error_no"]==0)
		{
			$extraData=$dataObj->request->extraData;
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "extraData"=>$extraData,
            );
            $checkResult=$this->getAccessToken($paramsObj);
            if($checkResult["error_no"]==0)
            {
                $accessTokenResult=$checkResult["result"];
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "extraData"=>$accessTokenResult,
                );
                $checkResult=$this->getUserInfo($paramsObj);
                if($checkResult["error_no"]==0)
                {
                    $userInfoResult=$checkResult["result"];
                    $return=array();
                    $return["userInfo"]=$userInfoResult;
                    $return["accessToken"]=$accessTokenResult;
                    $final_arr["result"]=$return;
                }
                else
                {
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
            else
            {
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
		}
		return $final_arr;
	}
}

?>