<?php

namespace app\utils\base\plugin;

use app\utils\seo\Sitemap;

class P_sitemaps
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //参数验证
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require|array',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        $savePath=publicPath();
        if($final_arr["error_no"]==0){
            //写入xml
            $sitemapFile=$savePath.config("sitemaps.sitemaps_xml","");
            if($sitemapFile){
                $xmlData=Sitemap::getXmlData($dataObj->request->data);
                $result=fileWrite($sitemapFile,$xmlData);
                if(!$result){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,"生成失败");
                }
            }
        }
        if($final_arr["error_no"]==0){
            //写入txt
            $sitemapFile=$savePath.config("sitemaps.sitemaps_txt","");
            if($sitemapFile){
                $txtData=Sitemap::getTxtData($dataObj->request->data);
                $result=fileWrite($sitemapFile,$txtData);
                if(!$result){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,"生成失败");
                }
            }
        }
        if($final_arr["error_no"]==0){
            //写入html
            $sitemapFile=$savePath.config("sitemaps.sitemaps_html","");
            $templateHtml=config("sitemaps.template_html","");
            if($sitemapFile && $templateHtml){
                $txtData=Sitemap::getHtmlData($templateHtml,$dataObj->request->data);
                $result=fileWrite($sitemapFile,$txtData);
                if(!$result){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,"生成失败");
                }
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}