<?php

namespace app\utils\base\plugin;

class P_reflection
{
    /**
     * 获取类信息
     * @param string $paramObj
     * @return array
     */
    public function getClassData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //参数验证
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'className' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try
            {
                $oReflectionClass = new \ReflectionClass($dataObj->request->className);
                $methods = $oReflectionClass->getMethods();
                $name=$oReflectionClass->getName();
                $shortName=$oReflectionClass->getShortName();

                $docClass=$oReflectionClass->getDocComment();
                $docClass=app("docParser")->parse($docClass);

                $data=array();
                foreach($methods as $val){
                    $doc=$val->getDocComment();
                    app("docParser")->init();
                    $result=app("docParser")->parse($doc);
                    if($val->class==$name && isset($result["actionName"])){
                        $result=array_merge($docClass,$result);
                        $data[]=array(
                            "shortName"=>$shortName,
                            "name"=>$val->name,
                            "doc"=>$result,
                        );
                    }
                }
                $final_arr["result"]=$data;
            }catch(\Exception $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::REFLECTION_ERROR,$e->getMessage());
            }
        }
        return $final_arr;
    }
}


