<?php

namespace app\utils\base\plugin;

class P_page
{
    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBar($data)
    {
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<span><a href="'.$href.'">'.lang("page.home").'</a></span>';

        $href = $baseUrl.($data["page"]-1);
        if($data["firstPage"]>1){
            $tem.='<span><a href="'.$href.'">'.lang("page.leftBtn").'</a></span>';
        }

        $tem.='<ul>';
        for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li class="active" ><a href="'.$href.'">'.$i.'</a></li>';
            }else{
                $tem.='<li><a href="'.$href.'">'.$i.'</a></li>';
            }
        }
        $tem.='</ul>';

        $href = $baseUrl.($data["page"]+1);
        if($data["lastPage"] < $data["totalPage"]){
            $tem.='<span><a href="'.$href.'">'.lang("page.rightBtn").'</a></span>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<span><a href="'.$href.'">'.lang("page.end").'</a></span>';
        return $tem;
    }

    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBarV2($data)
    {
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<a href="'.$href.'"><span>'.lang("page.home").'</span></a>';

        $href = $baseUrl.($data["page"]-1);
        if($data["firstPage"]>1){
            $tem.='<a href="'.$href.'"><span class="prev" >'.lang("page.pre").'</span></a>';
        }

        $tem.='<ul>';
        for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li><a class="page_active"  href="'.$href.'"><span>'.$i.'</span></a></li>';
            }else{
                $tem.='<li><a href="'.$href.'"><span>'.$i.'</span></a></li>';
            }
        }
        $tem.='</ul>';

        $href = $baseUrl.($data["page"]+1);
        if($data["lastPage"] < $data["totalPage"]){
            $tem.='<a href="'.$href.'"><span>'.lang("page.next").'</span></a>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';
        return $tem;
    }
}