<?php

namespace app\utils\base\helper;

class Ltcms_time
{
    /**
     * @brief  根据指定的格式输出时间
     * @param  String  $format 格式为年-月-日 时:分：秒,如‘Y-m-d H:i:s’
     * @param  String  $time   输入的时间
     * @return String  $time   时间
     */
    public static function getDateTime($format='',$time='',$timeZone=0)
    {
        $time   = $time   ? $time   : time();
        $time=is_numeric($time)?$time:strtotime($time);
        $format = $format ? $format : 'Y-m-d H:i:s';
        if($timeZone){
            $time=strtotime("+{$timeZone} hours",$time);
        }
        return date($format,$time);
    }

    /**
     * @brief  根据输入的时间返回时间戳
     * @param  $time String 输入的时间，格式为年-月-日 时:分：秒,如2010-01-01 00:00:00
     * @return $time Int 指定时间的时间戳
     */
    public static function getTime($time='')
    {
        if($time)
        {
            $time=is_numeric($time)?$time:strtotime($time);
            return $time;
        }
        return time();
    }

    /**
     * 获取utc时间
     * @return false|string
     */
    public static function getUtcTime()
    {
        $dateTime = new \DateTime('now');
        $offset = $dateTime->getOffset();
        $utcTimestamp = time() - $offset;
        return $utcTimestamp;
    }

    /**
     * 获取微妙时间戳
     * @param string $time
     * @return false|int|string
     */
    public static function getMsecTime()
    {
        list($msec, $sec) = explode(' ', microtime());
        $msec = (int)($msec * 1000);
        $timestamp = (int)$sec * 1000 + $msec;
        return $timestamp;
    }

    /**
     * 获取指定规则获取日期
     * @param $startDate
     * @param $endDate
     */
    public static function getTimeByRule($rules,$time="")
    {
        if($time){
            return strtotime($rules,$time);
        }else{
            return strtotime($rules);
        }
    }

    /**
     * 获取经过的天数
     * @param $time
     * @return float|int
     */
    public static function getPassDays($time)
    {
        $nowTime=time();
        $diffTime=$nowTime - $time;
        if($diffTime >0){
            return ceil($diffTime/86400);
        }else{
            return 0;
        }
    }
}