<?php

namespace app\utils\base\helper;

class Ltcms_confusion_code
{
    public  $hexContent="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";//62进制编码字符集
    public  $key=        "iYb2tRm5ZHcPAKkQwrUzT3EldgMeXOFj1DuIx6qVpo9SBv4nG0LJCsWNay7hf8";//密码本
    public  $startNumber=100000;
    public  $strlen=8;

    /**
     * 获取前缀长度
     */
    public function getPrefixNums(){
        $key_length=strlen($this->key);
        $prefix_nums=$key_length % $this->strlen;
        if($prefix_nums ==0){
            $prefix_nums=4;
        }
        return $prefix_nums;
    }

    /**
     * 获取前缀长度
     */
    public function getPrefix(){
        $prefix_nums=$this->getPrefixNums();
        $prefix=$this->generateRandomString($prefix_nums,$prefix_nums);
        return $prefix;
    }

    /**
     * 转换成字符串
     */
    public function enCode($number)
    {
        $prefix=$this->getPrefix();
        $number=$number+$this->startNumber;
        $dec62=$this->dec62($number);
        $replaceStr=$this->replaceStr($dec62);
        return $prefix.$replaceStr;
    }

    /**
     * 解码
     */
    public function deCode($str)
    {
        $prefix_nums=$this->getPrefixNums();
        $dec62=substr($str,$prefix_nums);
        $number=$this->dec10($this->deReplaceStr($dec62));
        $number=$number-$this->startNumber;
        return $number;
    }

    /**
     * 替换字符串
     * @param $str
     * @return string
     */
    public function replaceStr($str){
        $replace=array();
        $characters = str_split($str);
        foreach($characters as $val){
            $index=strpos($this->hexContent,$val);
            $replace[]=$this->key[$index];
        }
        return implode("",$replace);
    }

    /**
     * 替换回原字符串
     * @param $str
     * @return string
     */
    public function deReplaceStr($str){
        $replace=array();
        $characters = str_split($str);
        foreach($characters as $val){
            $index=strpos($this->key,$val);
            $replace[]=$this->hexContent[$index];
        }
        return implode("",$replace);
    }

    /**
     * 随机打乱数组
     * @param $str
     * @return string
     */
    public function shuffleString($str) {
        // 将字符串转换为数组
        $characters = str_split($str);
        // 随机打乱数组元素的顺序
        shuffle($characters);
        // 将数组重新组合成字符串
        $shuffledStr = implode('', $characters);
        return $shuffledStr;
    }


    /**
     * 获取随机字符串
     * @param int $length
     * @return string
     */
    public function generateRandomString($minLen = 5, $maxLen = 10)
    {
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        foreach (range(1, rand($minLen, $maxLen)) as $i) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * 10进制转为62进制
     *
     * @param integer $n 10进制数值
     * @return string 62进制
     */
    public function dec62($n) {
        $base = 62;
        $index = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $ret = '';
        for($t = floor(log10($n) / log10($base)); $t >= 0; $t --) {
            $a = floor($n / pow($base, $t));
            $ret .= substr($index, $a, 1);
            $n -= $a * pow($base, $t);
        }
        return $ret;
    }

    /**
     * 62进制转为10进制
     *
     * @param integer $n 62进制
     * @return string 10进制
     */
    public function dec10($s) {
        $base = 62;
        $index = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $ret = 0;
        $len = strlen($s) - 1;
        for($t = 0; $t <= $len; $t ++) {
            $ret += strpos($index, substr($s, $t, 1)) * pow($base, $len - $t);
        }
        return $ret;
    }
}