<?php

namespace app\third\api;

class T_software_upgrade
{
    /**
     * 最新版本数据
     * @param string $paramObj
     */
    public function lastInfo($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'project' => 'require',
                'stage' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["stage"] = $dataObj->request->stage;
            $data["project"] = $dataObj->request->project;
            $submitUrl = config("app.cmsUrl")."/api/softwareUpgradeVersion/lastInfo?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $body = toJsonDecode($result["body"]);
                if ($body["success"]) {
                    $final_arr["result"] = $body["data"];
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 版本信息
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["id"] = $dataObj->request->id;
            $submitUrl = config("app.cmsUrl")."/api/softwareUpgradeVersion/info?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $body = toJsonDecode($result["body"]);
                if ($body["success"]) {
                    $final_arr["result"] = $body["data"];
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新key
     * @param string $paramObj
     */
    public function updateKey($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'guid' => 'require',
                'domain' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["domain"] = $dataObj->request->domain;
            $data["guid"] = $dataObj->request->guid;
            $submitUrl = config("app.cmsUrl")."/api/cmssite/domainAuthStatus/info?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $body = toJsonDecode($result["body"]);
                if ($body["success"]) {
                    $data=$body["data"];
                    $keyContent=$data?$data["keyContent"]:"";
                    if($keyContent){
                        //写入key内容
                        $keyFile=LTCMS_ROOT."/auth/key.txt";
                        $keyDir=dirname($keyFile);
                        makeDir($keyDir);
                        file_put_contents($keyFile,$keyContent);
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.pleaseAuthFirst"));
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取下载文件
     * @param string $paramObj
     */
    public function getDownFile($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'incUp' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $currentVersion=app("L_Common_version")->currentInfo();
            $data = array();
            $data["id"] = $dataObj->request->id;
            $data["incUp"] = $dataObj->request->incUp;
            $data["version_nums"] = str_replace(".","",$currentVersion["version"]);//当前版本
            $data["version"] = $currentVersion["version"];//当前版本
            $submitUrl = config("app.cmsUrl")."/api/softwareUpgradeVersion/getDownFile?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $body = toJsonDecode($result["body"]);
                if ($body["success"]) {
                    $final_arr["result"] = $body["data"];
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}