<?php

namespace app\provider;

class AppProvider
{
    /**
     * 注册服务
     */
    public function register(){
        container()->bind([
            "errorLevel"=>'app\utils\error\Error_level',
            "errorCode"=>'app\utils\error\Error_code',
            "verifyParam"=>'app\utils\verify\Verify_param',
            "ltcmsTime"=>'app\utils\base\helper\Ltcms_time',
            "ltcmsConfusionCode"=>'app\utils\base\helper\Ltcms_confusion_code',

            "ltcmsSystemInfo"=>'app\utils\base\helper\Ltcms_system_info',
            "ltcmsFormat"=>'app\utils\base\helper\Ltcms_format',
            "ltcmsZip"=>'app\utils\base\helper\Ltcms_zip',
            "ltcmsRandName"=>'app\utils\base\helper\Ltcms_rand_name',
            "ltcmsDownload"=>'app\utils\base\helper\Ltcms_download',

            "page"=>'ltcms\lib\Page',
            "docParser"=>'app\utils\reflection\DocParser',
        ]);
    }

    /**
     * 服务启动
     */
    public function boot(){
        //插件加载逻辑
        $checkResult=app("L_Common_plugins")->getEnabledPlugins();
        if($checkResult["error_no"]=="0"){
            $plugin=$checkResult["result"];
            foreach($plugin as $pval){
                $classNamespace=$pval["pluginDir"]."/config";
                $classNamespace=str_replace("/","\\",$classNamespace);
                if(class_exists($classNamespace)){
                    $controllerObj=new $classNamespace;
                    if(method_exists($controllerObj,"init")){
                        @$controllerObj->init();
                    }
                }
            }
        }else{
            recordErrorLog($checkResult); //记录错误信息
        }
        //安装检测
        install()->check();
        $installedFile=LTCMS_ROOT."/plugins/ltcms_install/installed";
        if(is_file($installedFile)){
            //更新缓存
            upCache();
        }
    }
}