<?php

namespace app\middleware;

use \ltcms\middleware\Middleware_contract;

class isAdminLogin implements Middleware_contract
{
    /**
     *  处理请求
     */
    public function handle($request, \Closure $next)
    {
        //判断登录请求
        $isLogin=config("session.adminLogin.isLogin");
        if (session()->get($isLogin, "0") != "1") {
            if(request()->isAjax()){
                $response=apiResponse(false,lang("admin.pleaseLogin"),app("errorCode")::AUTH_ENTICATION);
                return jsonResponse($response);
            }else{
                header("content-type:text/html;charset=utf-8");
                echo getScriptContent(LTCMS_ROUTE_PREFIX."/login");
                exit;
            }
        }

        $response = $next($request);
        return $response;
    }
}


