<?php

namespace app\middleware;

use \ltcms\middleware\Middleware_contract;

class GlobalConfig implements Middleware_contract
{
    /**
     *  处理请求
     */
    public function handle($request,\Closure $next){
        //设置网站风格
        $siteSetting=siteSetting("");
        $seoSetting=seoSetting("");
//        if(isset($siteSetting["siteTemplateStyle"]) && $siteSetting["siteTemplateStyle"]){
//            config()->set("template.replace.__INDEX_STATIC__","/static/index/skin/{$siteSetting["siteTemplateStyle"]}");
//        }
        //设置网站模板
        if(isset($siteSetting["sitePcTemplateDir"]) && $siteSetting["sitePcTemplateDir"]){
            config()->set("site.pcTemplate",$siteSetting["sitePcTemplateDir"]);
        }
        //设置手机模版
        if(isset($siteSetting["siteMobileTemplate"]) && $siteSetting["siteMobileTemplate"]){
            config()->set("site.mobileTemplate",$siteSetting["siteMobileTemplate"]);
        }

        //设置网站标题
        $title="";
        $keywords="";
        $description="";

        if(isset($seoSetting["seoTitle"]) && $seoSetting["seoTitle"]){
            $title=$seoSetting["seoTitle"];
        }else if(isset($siteSetting["siteTitle"]) && $siteSetting["siteTitle"]){
            $title=$siteSetting["siteTitle"];
        }
        if(isset($seoSetting["seoKeyword"]) && $seoSetting["seoKeyword"]){
            $keywords=$seoSetting["seoKeyword"];
        }
        if(isset($seoSetting["seoDescription"]) && $seoSetting["seoDescription"]){
            $description=$seoSetting["seoDescription"];
        }

        if($title){
            config()->set("app.seo.title",$title);
        }
        if($keywords){
            config()->set("app.seo.keywords",$keywords);
        }
        if($description){
            config()->set("app.seo.description",$description);
        }
        $response=$next($request);
        return $response;
    }
}


