<?php

namespace app\logic\common;

class L_version
{
    /**
     * 获取当前版本信息
     * @param string $paramObj
     */
    public function info()
    {
        $return=$this->currentInfo();
        if($return){
            $return["lastVersion"]=array();
            //获取最新版本
            if(isset($return['project']) && isset($return['stage'])){
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'project' => $return['project'],
                    'stage' => $return['stage'],
                );
                $checkResult = app("T_Api_software_upgrade")->lastInfo($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if($result){
                        $compareOk=version_compare($result["version"],$return["version"]);
                        $return["lastVersion"]=$result;
                        $return["lastVersion"]["isNew"]=$compareOk;
                    }
                }
            }
        }
        return $return;
    }

    /**
     * 获取当前版本信息
     * @param string $paramObj
     */
    public function currentInfo()
    {
        $return=array();
        $versionFile=LTCMS_VERSION."/version";
        if(is_file($versionFile)){
            $versionContent=file_get_contents($versionFile);
            if($versionContent){
                $versionContent=array_filter(explode("\n",str_replace("\r","",$versionContent)));
                if($versionContent){
                    foreach($versionContent as $val){
                        $tmp=array_pad(explode("=",$val),2,"");
                        $return[$tmp[0]]=$tmp[1];
                    }
                }
            }
        }
        return $return;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}