<?php

namespace app\logic\common;

class L_caches
{
    /**
     * 操作缓存
     * @param string $paramObj
     */
    public function op($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'op' => 'require',
                'type' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->op=="up_cache"){
                //更新缓存
                $type=$dataObj->request->type?explode(",",$dataObj->request->type):null;
                delCache($type);
                upCache($type);
            }
        }
        return $final_arr;
    }

    /**
     * 写入文件
     * @param string $paramObj
     */
    public function saveToFile($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require',
                'name' => 'require',
                'dir' => 'require',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $name=$dataObj->request->name;
            $filePath=$dataObj->request->dir."{$name}.json";
            $filePath=str_replace("\\","/",$filePath);

            $checkUpdate=$this->checkUpdate($name,$dataObj->request->dir);
            $updateFilePath=$checkUpdate["file"];
            $updateRelayFilePath=$checkUpdate["fileRelay"];
            $updateFilePathLock=$updateFilePath."_lock";
            $dataJson=toJsonEncode($dataObj->request->data);

            //获取文章分类
            if(app("P_file")->mkdir($dataObj->request->dir)){
                if($fp = fopen($updateFilePathLock,"w")){
                    if (flock($fp, LOCK_EX|LOCK_NB)) {
                        file_put_contents($updateRelayFilePath,$dataJson);
                        file_put_contents($updateFilePath,"1");
                        file_put_contents($filePath,$dataJson);
                        file_put_contents($updateFilePath,"0");
                        flock($fp, LOCK_UN);    // 释放锁定
                    }else{
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OPEN_FAIL,lang("sys.openFail"),"被锁住了");
                    }
                }
            }else{
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OPEN_FAIL,lang("sys.openFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 删除文件
     * @param string $paramObj
     */
    public function delFile($name,$dir){
        $filePath=$dir."{$name}.json";
        $filePath=str_replace("\\","/",$filePath);

        if(is_file($filePath)){
            unlink($filePath);
        }
    }

    /**
     * 检测是否正在更新
     * @param $name
     * @return array
     */
    public function checkUpdate($name,$dir){
        $moduleUpdateFile=$dir."{$name}_update";
        $moduleUpdateFile=str_replace("\\","/",$moduleUpdateFile);

        $updateRelayFile=$dir."{$name}_update_tmp";
        $updateRelayFile=str_replace("\\","/",$updateRelayFile);

        $result=array(
            "status"=>false,
            "file"=>$moduleUpdateFile,
            "fileRelay"=>$updateRelayFile,
        );
        if(is_file($moduleUpdateFile)){
            $content=file_get_contents($moduleUpdateFile);
            if($content=="1"){
                $result["status"]=true;
            }
        }
        return $result;
    }

    /**
     * 初始化-网站设置
     * @param string $paramObj
     */
    public function initSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //检测缓存文件是否存在
            $dir=runtimePath("cache/setting");
            $all=$dir."all.json";
            if(!is_file($all)){
                $checkResult=app("S_Index_setting")->getSetting();
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            foreach($result as $key=>$val){
                                if($final_arr["error_no"]==0){
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "name"=>$key,
                                        "data"=>$val,
                                        "dir"=>$dir,
                                    );
                                    $checkResult=$this->saveToFile($paramsObj);
                                    if($checkResult["error_no"]==0){

                                    }else{
                                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                    }
                                }
                                if($final_arr["error_no"]){
                                    break;
                                }
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新网站设置
     * @param string $paramObj
     */
    public function updateSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'integer',
            );
            $dataDefault = array();
            $dataDefault["pid"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $checkResult=app("S_Index_setting")->getSetting();
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/setting");
                if($final_arr["error_no"]==0){
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            if($dataObj->request->pid && isset($result[$dataObj->request->pid])){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "name"=>$dataObj->request->pid,
                                    "data"=>$result[$dataObj->request->pid],
                                    "dir"=>$dir,
                                );
                                $checkResult=$this->saveToFile($paramsObj);
                                if($checkResult["error_no"]==0){

                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }else{
                                //删除文件
                                $this->delFile($dataObj->request->pid,$dir);
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取网站配置
     * @param string $paramObj
     */
    public function getSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => '',
                'pid' => 'require',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/setting"));

            $settingPath=$dir."{$dataObj->request->pid}.json";
            $settingAllPath=$dir."all.json";
            if($dataObj->request->pid=="all"){
                $is_updateing=$this->checkUpdate("all",$dir);
                if($is_updateing["status"]){
                    $settingAllPath=$is_updateing["fileRelay"];
                }
                if($settingAllPath){
                    $content=file_get_contents($settingAllPath);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
                $sysId=config("setting.sysId",array());
                $existsId=array();
                if($dataObj->data->content){
                    foreach($dataObj->data->content as $key=>$val){
                        $dataObj->data->content[$key]=array_merge(config("setting.{$key}",array()),$val);
                        $moduleType=module($key,"module"); //检测是否有对应模块默认设置
                        if($moduleType){
                            $dataObj->data->content[$key]=array_merge(config("setting.{$moduleType}",array()),$dataObj->data->content[$key]);
                        }
                        if(in_array($key,$sysId)){
                            $existsId[]=$key;
                        }
                    }
                }
                //未存储ID
                $diffId=array_diff($sysId,$existsId);
                if($diffId){
                    foreach($diffId as $dval){
                        $dataObj->data->content[$dval]=config("setting.{$dval}",array());
                    }
                }
            }else{
                if(is_file($settingPath)){
                    $is_updateing=$this->checkUpdate($dataObj->request->pid,$dir);
                    if($is_updateing["status"]){
                        $settingPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingPath)){
                        $content=file_get_contents($settingPath);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }else{
                    $is_updateing=$this->checkUpdate("all",$dir);
                    if($is_updateing["status"]){
                        $settingAllPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingAllPath)){
                        $content=file_get_contents($settingAllPath);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataObj->request->pid])?$content[$dataObj->request->pid]:array();
                    }
                }
                $dataObj->data->content=array_merge(config("setting.{$dataObj->request->pid}",array()),$dataObj->data->content);
                $moduleType=module($dataObj->request->pid,"module"); //检测是否有对应模块默认设置
                if($moduleType){
                    $dataObj->data->content=array_merge(config("setting.{$moduleType}",array()),$dataObj->data->content);
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]=null;
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 初始化-模块数据
     * @param string $paramObj
     */
    public function initModule($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //检测缓存文件是否存在
            $dir=runtimePath("cache/module");
            $all=$dir."all.json";
            if(!is_file($all)){
                $checkResult=app("S_Admin_module")->allData();
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            foreach($result as $key=>$val){
                                if($final_arr["error_no"]==0){
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "name"=>$key,
                                        "data"=>$val,
                                        "dir"=>$dir,
                                    );
                                    $checkResult=$this->saveToFile($paramsObj);
                                    if($checkResult["error_no"]==0){

                                    }else{
                                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                    }
                                }
                                if($final_arr["error_no"]){
                                    break;
                                }
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新模块数据
     * @param string $paramObj
     */
    public function updateModule($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'integer',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $checkResult=app("S_Admin_module")->allData();
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/module");
                if($final_arr["error_no"]==0){
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            if($dataObj->request->id && isset($result[$dataObj->request->id])){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "name"=>$dataObj->request->id,
                                    "data"=>$result[$dataObj->request->id],
                                    "dir"=>$dir,
                                );
                                $checkResult=$this->saveToFile($paramsObj);
                                if($checkResult["error_no"]==0){

                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }else{
                                //删除文件
                                $this->delFile($dataObj->request->id,$dir);
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取模块数据
     * @param string $paramObj
     */
    public function getModule($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/module"));

            $settingPath=$dir."{$dataObj->request->id}.json";
            $settingAllPath=$dir."all.json";
            if($dataObj->request->id=="all"){
                $is_updateing=$this->checkUpdate("all",$dir);
                if($is_updateing["status"]){
                    $settingAllPath=$is_updateing["fileRelay"];
                }
                if($settingAllPath){
                    $content=file_get_contents($settingAllPath);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
                if($dataObj->data->content){
                    foreach($dataObj->data->content as $moduleId=>$moduleVal){
                        $dataObj->data->content[$moduleId]["linkUrl"]=moduleLinkUrl($moduleVal);
                    }
                }
            }else{
                if(is_file($settingPath)){
                    $is_updateing=$this->checkUpdate($dataObj->request->id,$dir);
                    if($is_updateing["status"]){
                        $settingPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingPath)){
                        $content=file_get_contents($settingPath);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }else{
                    $is_updateing=$this->checkUpdate("all",$dir);
                    if($is_updateing["status"]){
                        $settingAllPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingAllPath)){
                        $content=file_get_contents($settingAllPath);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataObj->request->id])?$content[$dataObj->request->id]:array();
                    }
                }
                if($dataObj->data->content){
                    $dataObj->data->content["linkUrl"]=moduleLinkUrl($dataObj->data->content);
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]=null;
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 获取模块数据
     * @param string $paramObj
     */
    public function getModuleByCatDir($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'catDir' => 'require',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/module"));

            $settingAllPath=$dir."all.json";
            $is_updateing=$this->checkUpdate("all",$dir);
            if($is_updateing["status"]){
                $settingAllPath=$is_updateing["fileRelay"];
            }
            if($settingAllPath){
                $content=file_get_contents($settingAllPath);
                $dataObj->data->content=$content?toJsonDecode($content):array();
            }
            if($dataObj->data->content){
                foreach($dataObj->data->content as $moduleId=>$moduleVal){
                    $dataObj->data->content[$moduleId]["linkUrl"]=moduleLinkUrl($moduleVal);
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if($dataObj->data->content){
                    foreach($dataObj->data->content as $val){
                        if($val["plugins"]==$dataObj->request->catDir){
                            if(isset($val[$dataObj->request->itemKey])){
                                $final_arr["result"]=$val[$dataObj->request->itemKey];
                            }else{
                                $final_arr["result"]=null;
                            }
                            break;
                        }
                    }
                }else{
                    $final_arr["result"]=null;
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 初始化-分类数据
     * @param string $paramObj
     */
    public function initCategory($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //检测缓存文件是否存在
            $dir=runtimePath("cache/category");
            $all=$dir."all.json";
            if(!is_file($all)){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "format"=>"cache",
                );
                $checkResult=app("S_Admin_category")->allData($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            foreach($result as $key=>$val){
                                if($final_arr["error_no"]==0){
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "name"=>$key,
                                        "data"=>$val,
                                        "dir"=>$dir,
                                    );
                                    $checkResult=$this->saveToFile($paramsObj);
                                    if($checkResult["error_no"]==0){

                                    }else{
                                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                    }
                                }
                                if($final_arr["error_no"]){
                                    break;
                                }
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新分类数据
     * @param string $paramObj
     */
    public function updateCategory($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => '',
            );
            $dataDefault = array();
            $dataDefault["dataId"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "format"=>"cache",
            );
            $checkResult=app("S_Admin_category")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/category");
                if($final_arr["error_no"]==0){
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            $fileName=$dataObj->request->dataType."_".$dataObj->request->dataId;
                            if(isset($result[$fileName])){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "name"=>$fileName,
                                    "data"=>$result[$fileName],
                                    "dir"=>$dir,
                                );
                                $checkResult=$this->saveToFile($paramsObj);
                                if($checkResult["error_no"]==0){

                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }else{
                                //删除文件
                                $this->delFile($fileName,$dir);
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取分类数据
     * @param string $paramObj
     */
    public function getCategory($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => 'require',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/category"));

            $dataType=$dataObj->request->dataType;
            $dataId=$dataObj->request->dataId;
            $fileName="{$dataType}_{$dataId}";

            $settingPath=$dir."{$fileName}.json";
            $settingAllPath=$dir."all.json";
            if($dataId=="all"){
                $is_updateing=$this->checkUpdate("all",$dir);
                if($is_updateing["status"]){
                    $settingAllPath=$is_updateing["fileRelay"];
                }
                if($settingAllPath){
                    $content=file_get_contents($settingAllPath);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
            }else{
                if(is_file($settingPath)){
                    $is_updateing=$this->checkUpdate($fileName,$dir);
                    if($is_updateing["status"]){
                        $settingPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingPath)){
                        $content=file_get_contents($settingPath);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }else{
                    $is_updateing=$this->checkUpdate("all",$dir);
                    if($is_updateing["status"]){
                        $settingAllPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingAllPath)){
                        $content=file_get_contents($settingAllPath);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$fileName])?$content[$fileName]:array();
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]=null;
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 初始化-字段数据
     * @param string $paramObj
     */
    public function initFields($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //检测缓存文件是否存在
            $dir=runtimePath("cache/fields");
            $all=$dir."all.json";
            if(!is_file($all)){
                $checkResult=app("S_Index_fields")->allData();
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            foreach($result as $key=>$val){
                                if($final_arr["error_no"]==0){
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "name"=>$key,
                                        "data"=>$val,
                                        "dir"=>$dir,
                                    );
                                    $checkResult=$this->saveToFile($paramsObj);
                                    if($checkResult["error_no"]==0){

                                    }else{
                                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                    }
                                }
                                if($final_arr["error_no"]){
                                    break;
                                }
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新-字段数据
     * @param string $paramObj
     */
    public function updateFields($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'integer',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $checkResult=app("S_Index_fields")->allData();
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/fields");
                if($final_arr["error_no"]==0){
                    if($result){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>"all",
                                "data"=>$result,
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]==0){
                            if($dataObj->request->id && isset($result[$dataObj->request->id])){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "name"=>$dataObj->request->id,
                                    "data"=>$result[$dataObj->request->id],
                                    "dir"=>$dir,
                                );
                                $checkResult=$this->saveToFile($paramsObj);
                                if($checkResult["error_no"]==0){

                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }else{
                                //删除文件
                                $this->delFile($dataObj->request->id,$dir);
                            }
                        }
                    }else{
                        //删除文件夹
                        dirDelete($dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取-字段数据
     * @param string $paramObj
     */
    public function getFields($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/fields"));

            $settingPath=$dir."{$dataObj->request->id}.json";
            $settingAllPath=$dir."all.json";
            if($dataObj->request->id=="all"){
                $is_updateing=$this->checkUpdate("all",$dir);
                if($is_updateing["status"]){
                    $settingAllPath=$is_updateing["fileRelay"];
                }
                if($settingAllPath){
                    $content=file_get_contents($settingAllPath);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
            }else{
                if(is_file($settingPath)){
                    $is_updateing=$this->checkUpdate($dataObj->request->id,$dir);
                    if($is_updateing["status"]){
                        $settingPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingPath)){
                        $content=file_get_contents($settingPath);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }else{
                    $is_updateing=$this->checkUpdate("all",$dir);
                    if($is_updateing["status"]){
                        $settingAllPath=$is_updateing["fileRelay"];
                    }
                    if(is_file($settingAllPath)){
                        $content=file_get_contents($settingAllPath);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataObj->request->id])?$content[$dataObj->request->id]:array();
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]=null;
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}