<?php

namespace app\logic\api;

class L_sitemaps
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $savePath=publicPath();
            $sitemaps=extendSetting("sitemaps");
            $sitemaps_xml=$savePath.config("sitemaps.sitemaps_xml","");
            $sitemaps_txt=$savePath.config("sitemaps.sitemaps_txt","");
            $sitemaps_html=$savePath.config("sitemaps.sitemaps_html","");
            if(!$sitemaps){
                if($sitemaps_xml && is_file($sitemaps_xml)){
                    unlink($sitemaps_xml);
                }
                if($sitemaps_txt && is_file($sitemaps_txt)){
                    unlink($sitemaps_txt);
                }
                if($sitemaps_html && is_file($sitemaps_html)){
                    unlink($sitemaps_html);
                }
            }else{
                //获取站点模版内容
                $sitemapsFile=config("sitemaps.generate");
                if($sitemapsFile && is_file($sitemapsFile)){
                    $ok=include $sitemapsFile;
                    if(!$ok){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
                    }
                }else{
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
                }
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}