<?php

namespace app\logic\api;

use app\utils\signApi\signV1;
use app\client\api\C_goods;

class L_goods
{
    /**
     * 已安装插件
     * @param string $paramObj
     */
    public function installedPlugin($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'url' => '',
                'name' => '',
                'page' => '',
                'pageSize' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "page"=>$dataObj->request->page,
                "pageSize"=>$dataObj->request->pageSize,
                "name"=>$dataObj->request->name,
            );
            $checkResult=app("L_Common_plugins")->getInstalledPluginsPage($paramsObj);
            if($checkResult["error_no"]=="0"){
                $pluginResult=$checkResult["result"];
                if($pluginResult){
                    //获取已安装文件ID
                    $installPluginIds=array_filter(array_map(array($this,"filterIds"),array_column($pluginResult["data"],"id")));
                    if($installPluginIds){
                        $paramsObj = paramsObj();
                        $paramsObj->params = array(
                            "ids" => $installPluginIds,
                            "url" => config("app.url"),
                        );
                        $c_goods=new C_goods();
                        $response = $c_goods->goodList($paramsObj);
                        $listData = array();
                        if ($response["success"]) {
                            foreach($response["data"]["data"] as $val){
                                $listData[$val["id"]]=$val;
                            }
                        }
                        if($listData){
                            foreach($pluginResult["data"] as $key=>$val){
                                if($val["id"] && isset($listData[$val["id"]])){
                                    $pluginResult["data"][$key]=$listData[$val["id"]];
                                }
                            }
                        }
                    }
                }
                $final_arr["result"]=$pluginResult;
            }
        }
        return $final_arr;
    }

    /**
     * 过滤ID
     * @param $val
     * @return int
     */
    public function filterIds($val){
        if($val >0){
            return $val;
        }
        return 0;
    }

    /**
     * 获取商品数据
     * @param string $paramObj
     */
    public function goodList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'ids' => '',
                'url' => '',
                'categoryId' => '',
                'name' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "name"=>$dataObj->request->name,
            );
            $checkResult=app("L_Common_plugins")->getInstalledPlugins($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->pluginsResult=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'ids' => $dataObj->request->ids,
                'url' => $dataObj->request->url,
                'categoryId' => $dataObj->request->categoryId,
                'name' => $dataObj->request->name,
            );
            $checkResult = $this->pluginList($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $goodsResult=$checkResult["result"];
                if($dataObj->data->pluginsResult && $goodsResult["data"]){
                    foreach($goodsResult["data"] as $key=>$val){
                        $val["pluginData"]["install"]=0;
                        $pluginDir=isset($val["pluginData"]["pluginDir"])?$val["pluginData"]["pluginDir"]:"";
                        if($pluginDir && isset($dataObj->data->pluginsResult[$pluginDir])){
                            $val["pluginData"]["setting"]=$dataObj->data->pluginsResult[$pluginDir]["setting"];
                            $val["pluginData"]["install"]=1;
                        }
                        $goodsResult["data"][$key]=$val;
                    }
                }
                $final_arr["result"]=$goodsResult;
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 插件列表
     * @param string $paramObj
     */
    public function pluginList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'ids' => '',
                'url' => '',
                'categoryId' => '',
                'name' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $loginUserData=\Ltcms_domain_auth_check_key::loginData();
            $guid=getVal($loginUserData,"guid","");

            $data = array();
            $data["categoryId"] = $dataObj->request->categoryId;
            $data["name"] = $dataObj->request->name;
            $data["url"] = $dataObj->request->url;
            $data["ids"] = $dataObj->request->ids;
            $data["guid"] = $guid;
            $data["showInStore"] = 1;
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_shop/plugin?" . http_build_query($data);
            $paramsObj = paramsObj();
            // 解析 URL 查询字符串
            parse_str(parse_url($submitUrl, PHP_URL_QUERY), $data);
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 解析token
     * @param string $paramObj
     */
    public function parseToken($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'token' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["token"] = $dataObj->request->token;
            $data["tokenType"] = "bearer";
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_member/authToken/parseToken?" . http_build_query($data);
            $header=getSignV1($data);
            $paramsObj = paramsObj();
            // 解析 URL 查询字符串
            parse_str(parse_url($submitUrl, PHP_URL_QUERY), $data);
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "post",
                "time" => 10,
                "headers" => $header,
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新key
     * @param string $paramObj
     */
    public function updateKey($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取登录信息
            $loginUserData=\Ltcms_domain_auth_check_key::loginData();
            $guid=getVal($loginUserData,"guid","");
            if(!$guid){  //提示未登录
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.updateKey"));
            }
            if ($final_arr["error_no"] == 0) {
                $domain=request()->host();
                $params = array();
                $params["domain"] = $domain;
                $params["guid"] = $guid;
                $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_domain_auth/domainAuthStatusUser/authorizeKey?" . http_build_query($params);
                $paramsObj = paramsObj();
                // 解析 URL 查询字符串
                parse_str(parse_url($submitUrl, PHP_URL_QUERY), $params);
                $paramsObj->params = array(
                    "submitUrl" => $submitUrl,
                    "method" => "get",
                    "time" => 10,
                    "headers" => getSignV1($params),
                );
                $checkResult = app("P_http")->send($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result = $checkResult["result"];
                    if ($result["httpCode"] == "200") {
                        $body = toJsonDecode($result["body"]);
                        if ($body["success"]) {
                            $data = $body["data"];
                            if($data){
                                $keyContent=$data["keyContent"];
                                if($keyContent){
                                    //写入key内容
                                    $keyFile=LTCMS_ROOT."/auth/key.txt";
                                    $keyDir=dirname($keyFile);
                                    makeDir($keyDir);
                                    file_put_contents($keyFile,$keyContent);
                                }
                            }
                        } else {
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                        }
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新白名单
     * @param string $paramObj
     */
    public function updateWhiteList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取登录信息
            $loginUserData=\Ltcms_domain_auth_check_key::loginData();
            $guid=getVal($loginUserData,"guid","");
            if(!$guid){  //提示未登录
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.updateKey"));
            }
            if ($final_arr["error_no"] == 0) {
                $params = array();
                $params["guid"] = $guid;
                $submitUrl = config("app.cmsSiteUrl")."/api/domain/auth/whiteList?" . http_build_query($params);
                $paramsObj = paramsObj();
                // 解析 URL 查询字符串
                parse_str(parse_url($submitUrl, PHP_URL_QUERY), $params);
                $paramsObj->params = array(
                    "submitUrl" => $submitUrl,
                    "method" => "post",
                    "time" => 10,
                    "headers" => getSignV1($params),
                );
                $checkResult = app("P_http")->send($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result = $checkResult["result"];
                    if ($result["httpCode"] == "200") {
                        $body = toJsonDecode($result["body"]);
                        if ($body["success"]) {
                            $keyContent = $body["data"];
                            if($keyContent){
                                $keyDir=runtimePath("cache/domain_auth_status");
                                $whiteListFile=$keyDir."white_list";
                                makeDir($keyDir);
                                file_put_contents($whiteListFile,$keyContent);
                            }
                        } else {
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                        }
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 获取程序版本
     * @param string $paramObj
     */
    public function cmsProject($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $params = array();
            $params["field"]="id,name";
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_domain_auth/cmsProject/getData?". http_build_query($params);
            $paramsObj = paramsObj();
            // 解析 URL 查询字符串
            parse_str(parse_url($submitUrl, PHP_URL_QUERY), $params);
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($params),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 插件分类
     * @param string $paramObj
     */
    public function pluginCategory($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["showInStore"]=1;
            $submitUrl = config("app.cmsSiteUrl")."/shop/goodsCategory?" . http_build_query($data);
            $paramsObj = paramsObj();
            // 解析 URL 查询字符串
            parse_str(parse_url($submitUrl, PHP_URL_QUERY), $data);
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 插件详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["id"] = $dataObj->request->id;
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_shop/plugin/info?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 10,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}