<?php

namespace app\logic\admin;

use app\utils\encrypt\Hash_pbkdf2;

class L_user
{
    public function serAdminPassword($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();  //请求
        $dataObj->data = paramsObj();        //data  数据
        $dataObj->data->use_trans = false;    // 是否使用use_trans
        $dataObj->result = array();           //结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();               //日志初始化
        //校验数据合法
        if ($final_arr["error_no"] == 0) {
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'password' => '',
                'newPassword' => '',
                'newPassword2' => '',
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->mixed = 1;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = array();

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
                $dataObj->request->id = session()->get("uid");

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->newPassword != $dataObj->request->newPassword2) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang2("两次新密码不一致,请重新输入"));
            }
        }
        //判断管理员id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {

            $dataObj->params = ["id" => session()->get("uid")];
            $checkResult = app("S_Admin_memberAdmin")->info($dataObj);
            if ($checkResult["error_no"] == "0") {
                $dataObj->adminInfo = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST || $final_arr["error_no"] == app("errorCode")::VERIFY_DATA_FAIL) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员id不存在";
            }
        }


        if ($final_arr["error_no"] == 0) {
            try {   //其实就是sha256摘要算法, 只是返回的值增加了盐,并编码, 盐不参与计算  验证时,会先解码值然后获取前面摘要结果,在对比,
                if (!Hash_pbkdf2::decrypt($dataObj->request->password, $dataObj->adminInfo["password"])) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, "原密码错误");
                }

            } catch (\Exception $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, $e->getMessage());
            }

        }

        if ($final_arr["error_no"] == 0) {

            $checkResult = app("S_Admin_memberAdmin")->setPassword($dataObj);
            if ($checkResult["error_no"] == "0") {
                $dataObj->data->adminInfo = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    //管理员登录接口
    public function login($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();  //请求
        $dataObj->data = paramsObj();        //data  数据
        $dataObj->data->use_trans = false;    // 是否使用use_trans
        $dataObj->result = array();           //结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();               //日志初始化
        //校验数据合法
        if ($final_arr["error_no"] == 0) {
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'account' => 'require',
                'password' => 'require',
                'captcha' => 'require',
            ));
            $messages=array();
            $messages["account.require"]="请输入账号名称";
            $messages["password.regex"]="请输入密码";
            $messages["captcha.require"]="请输入验证码";
            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->mixed = 1;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = array();

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $captcha_txt=session()->get("captcha_txt");
            if(!$captcha_txt || $dataObj->request->captcha != $captcha_txt){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("admin.captchaError"));
            }
        }
        //获取管理员信息
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "user" => $dataObj->request->account,
            );
            $checkResult = app("S_Admin_memberAdmin")->getUser($paramsObj);
            if ($checkResult["error_no"] == "0") {
                $dataObj->adminInfo = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST || $final_arr["error_no"] == app("errorCode")::VERIFY_DATA_FAIL) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员不存在";
            }
        }


        if ($final_arr["error_no"] == 0) {
            try {   //其实就是sha256摘要算法, 只是返回的值增加了盐,并编码, 盐不参与计算  验证时,会先解码值然后获取前面摘要结果,在对比,
                if (!Hash_pbkdf2::decrypt($dataObj->request->password, $dataObj->adminInfo["password"])) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, "密码错误");
                } else {
                    $final_arr["result"] = ["User" => $dataObj->adminInfo["user"]];
                }

            } catch (\Exception $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, $e->getMessage());
            }

        }

        if ($final_arr["error_no"] == 0) {
            try {
                if ($dataObj->adminInfo["status"] != 1) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, "账号未启用");
                } else {
                    $final_arr["result"] = ["User" => $dataObj->adminInfo["user"]];
                }

            } catch (\Exception $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, $e->getMessage());
            }

        }

        if ($final_arr["error_no"] == 0) {
            session()->set("isLogin", "1");
            session()->set("uid", $dataObj->adminInfo["id"]);   //与前台值不一样,前台用户为guid
            session()->set("adminInfo", $dataObj->adminInfo);   //
            log_operation($dataObj->adminInfo["user"],"后台登录","登录成功");
        }
        return $final_arr;
    }


    //获取登陆用户详细信息
    public function getInfo($paramObj = "")
    {

        $dataObj = paramsObj();
        $dataObj->request = paramsObj();  //请求
        $dataObj->data = paramsObj();        //data  数据
        $dataObj->data->use_trans = false;    // 是否使用use_trans
        $dataObj->result = array();           //结果

        $final_arr = logInit();               //日志初始化

        //获取管理员信息
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'id' => session()->get("uid"),
                'field' => "id,user,roleId",
            );
            $adminInfo = app("S_Admin_memberAdmin")->info($paramsObj);
            if ($adminInfo["error_no"] == "0") {
                $final_arr["result"] = $adminInfo["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $adminInfo);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST || $final_arr["error_no"] == app("errorCode")::VERIFY_DATA_FAIL) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员不存在";
            }
        }

        return $final_arr;
    }

    //获取登陆用户详细信息
    public function getUserMenu($paramObj = "")
    {

        $dataObj = paramsObj();
        $dataObj->request = paramsObj();  //请求
        $dataObj->data = paramsObj();        //data  数据
        $dataObj->data->use_trans = false;    // 是否使用use_trans
        $dataObj->result = array();           //结果

        $final_arr = logInit();               //日志初始化

        //获取管理员信息
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'id' => session()->get("uid"),
                'field' => "id,user,roleId,isAdmin",
            );
            $adminInfo = app("S_Admin_memberAdmin")->info($paramsObj);
            if ($adminInfo["error_no"] == "0") {
                $dataObj->data->adminInfo = $adminInfo["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $adminInfo);
            }
            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST || $final_arr["error_no"] == app("errorCode")::VERIFY_DATA_FAIL) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员不存在";
            }
        }

        //超级管理员直接获取全部
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->data->adminInfo["isAdmin"] == 1)
                return $this->getMenuAll();
        }

        //获取管理员角色拥有功能ids
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'roleId' => $dataObj->data->adminInfo["roleId"],
            );
            $result = app("S_Admin_adminRoleFunc")->getRoleBindFunc($paramsObj);
            if ($result["error_no"] == "0") {
                $dataObj->data->RoleBindFunc = $result["result"];

                if (!$dataObj->data->RoleBindFunc) {
                    //修改一下返回提示
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang2("未授权任何功能"));
                }

            } else {
                $final_arr = logCallErrorMsg($final_arr, $result);
            }
        }

        //通过功能ids获取菜单ids
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'ids' => $dataObj->data->RoleBindFunc,
                "isShow"=>1,
                "isEnable"=>1,
                'field' => "id,menuId,route,routhAction,sort,isShow,actionName",
            );
            $result = app("S_Admin_adminFunc")->infos($paramsObj);
            if ($result["error_no"] == "0") {
                $dataObj->data->funcIdsInfo = $result["result"];//备用
                $dataObj->data->memuids = array();
                foreach ($dataObj->data->funcIdsInfo as $key => $val) {
                    $dataObj->data->memuids[] = $val["menuId"];
                };
                $dataObj->data->memuids = array_unique($dataObj->data->memuids);
            } else {
                $final_arr = logCallErrorMsg($final_arr, $result);
            }
        }
        //通过菜单ids获取菜单idsInfo
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'ids' => $dataObj->data->memuids,
                'status' => 1,
            );

            $result = app("S_Admin_adminMenu")->infos($paramsObj);
            if ($result["error_no"] == "0") {
                $dataObj->data->menuIdsInfo = $result["result"];//备用

                foreach ($dataObj->data->menuIdsInfo as $key => $val) {
                    if ($val["pid"] > 0) {
                        $dataObj->data->memuPids[] = $val["pid"];
                    }
                };
            } else {
                $final_arr = logCallErrorMsg($final_arr, $result);
            }
        }

        //通过菜单ids循环获取上级菜单pidsInfo
        if ($final_arr["error_no"] == 0) {
            for ($i = 0; count($dataObj->data->memuPids) > 0; $i++) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'ids' => $dataObj->data->memuPids,
                    'status' => 1,
                );
                $result = app("S_Admin_adminMenu")->infos($paramsObj);

                if ($result["error_no"] == "0") {
                    $dataObj->data->menuIdsInfo = array_merge($dataObj->data->menuIdsInfo, $result["result"]);//备用
                    $dataObj->data->memuPids = [];
                    //继续查上级
                    foreach ($result["result"] as $key => $val) {
                        if ($val["pid"] > 0) {
                            $dataObj->data->memuPids[] = $val["pid"];
                        }
                    };
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $result);
                    break;
                }
            }
        }
        //总结整理数据
        if ($final_arr["error_no"] == 0) {
            $final_arr["result"] = array(
                "menuIdsInfo" => (new L_adminMenu())->buildTree($dataObj->data->menuIdsInfo),
                "funcIdsInfo" => $dataObj->data->funcIdsInfo,
            );
        }

        return $final_arr;
    }


    //获取全部菜单+功能 方法 超级管理员菜单  角色功能绑定列表菜单
    public function getMenuAll($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();  //请求
        $dataObj->data = paramsObj();        //data  数据
        $dataObj->data->use_trans = false;    // 是否使用use_trans
        $dataObj->result = array();           //结果
        $final_arr = logInit();               //日志初始化

        //获取全部功能ids
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "isShow"=>1,
                'field' => "id,menuId,route,routhAction,sort,isShow,actionName",
            );
            $result = app("S_Admin_adminFunc")->getAll($paramsObj);
            if ($result["error_no"] == "0") {
                $dataObj->data->funcIdsInfo = $result["result"];//备用
                $dataObj->data->memuids = array();
                foreach ($dataObj->data->funcIdsInfo as $key => $val) {
                    $dataObj->data->memuids[] = $val["menuId"];
                };
                $dataObj->data->memuids = array_unique($dataObj->data->memuids);
            } else {
                $final_arr = logCallErrorMsg($final_arr, $result);
            }
        }
        //通过菜单ids获取菜单idsInfo
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'ids' => $dataObj->data->memuids,
                'status' => 1,
            );
            $result = app("S_Admin_adminMenu")->infos($paramsObj);
            if ($result["error_no"] == "0") {
                $dataObj->data->menuIdsInfo = $result["result"];//备用

                foreach ($dataObj->data->menuIdsInfo as $key => $val) {
                    if ($val["pid"] > 0) {
                        $dataObj->data->memuPids[] = $val["pid"];
                    }
                };
            } else {
                $final_arr = logCallErrorMsg($final_arr, $result);
            }
        }

        //通过菜单ids循环获取上级菜单pidsInfo
        if ($final_arr["error_no"] == 0) {
            for ($i = 0; count($dataObj->data->memuPids) > 0; $i++) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'ids' => $dataObj->data->memuPids,
                    'status' => 1,
                );
                $result = app("S_Admin_adminMenu")->infos($paramsObj);

                if ($result["error_no"] == "0") {
                    $dataObj->data->menuIdsInfo = array_merge($dataObj->data->menuIdsInfo, $result["result"]);//备用
                    $dataObj->data->memuPids = [];
                    //继续查上级
                    foreach ($result["result"] as $key => $val) {
                        if ($val["pid"] > 0) {
                            $dataObj->data->memuPids[] = $val["pid"];
                        }
                    };
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $result);
                    break;
                }
            }
        }
        //总结整理数据
        if ($final_arr["error_no"] == 0) {
            $final_arr["result"] = array(
                "menuIdsInfo" => (new L_adminMenu())->buildTree($dataObj->data->menuIdsInfo),
                "funcIdsInfo" => $dataObj->data->funcIdsInfo,
            );
        }

        return $final_arr;
    }
}