<?php

namespace app\logic\admin;

class L_singlePage
{

    /**
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                "item" => "",
                "level" => "between:0,127",
                "title" => "max:100",
                "color" => "",
                "path" => "",
                "file" => "",
                "seoTitle" => "",
                "seoKeywords" => "",
                "seoDescription" => "",
                "sort" => "",
                "isLink" => "",
                "linkUrl" => "",
                "domain" => "",
                "template" => "",
                "content" => "",
            );
            $dataDefault = array(
                "item" => "1",
                "level" => "1",
                "sort" => "1",
                "isLink" => 0,
                "content" => " ",               //text 字段不能设置默认值,而且添加时必须有值  但是外部链接是没有这个值,所有默认空字符串
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }


        if ($final_arr["error_no"] == 0) {
            //调用 数据库层代理执行
            $tempObg = getParamsObj();
            $tempObg->params = parseToArr($dataObj, "request", array());

            if ($dataObj->request->domain){
                $tempObg->params["domain"]= trim($dataObj->request->domain,"/"); //删掉结尾的/
            }

            if (!$dataObj->request->file){
                $dataObj->request->file="{id}.html";
            }

            //检测路径左右两侧是否有 "/"
            if (substr($dataObj->request->path, 0, 1) !== "/") {
                $dataObj->request->path = "/" . $dataObj->request->path;
            }
            if (substr($dataObj->request->path, -1) !== "/") {
                $dataObj->request->path = $dataObj->request->path . "/";
            }

            if ($dataObj->request->isLink) { //外部链接或文件相对路径+文件名
                //外部链接不用改 linkurl
                $tempObg->params["isLink"] = 1;
            } else {
                //非外部链接需要组合文件名
                $tempObg->params["isLink"] = 0;
                $tempObg->params["linkUrl"] = $dataObj->request->path . $dataObj->request->file;
            }
            if ($dataObj->request->color) {
                //外部链接不用改 linkurl
                $tempObg->params["style"] = "color:" . $dataObj->request->color . ";";
            }


            $checkResult = app("S_Admin_singlePage")->store($tempObg);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];  //吧响应结果数据赋值到最终数组 结果数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    /**
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                "id" => "",
                "item" => "",
                "level" => "between:0,127",
                "title" => "max:100",
                "color" => "",
                "path" => "",
                "file" => "",
                "seoTitle" => "",
                "seoKeywords" => "",
                "seoDescription" => "",
                "sort" => "",
                "isLink" => "",
                "linkUrl" => "",
                "domain" => "",
                "template" => "",
                "content" => "",
            );
            $dataDefault = array(
                "isLink" => 0,
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }


        if ($final_arr["error_no"] == 0) {
            //调用 数据库层代理执行
            $tempObg = getParamsObj();
            $tempObg->params = parseToArr($dataObj, "request", array());

            if ($dataObj->request->domain){
                $tempObg->params["domain"]= trim($dataObj->request->domain,"/"); //删掉结尾的/
            }

            if (!$dataObj->request->file){
                $dataObj->request->file=$dataObj->request->id.".html";
            }

            //检测路径左右两侧是否有 "/"
            if (substr($dataObj->request->path, 0, 1) !== "/") {
                $dataObj->request->path = "/" . $dataObj->request->path;
            }
            if (substr($dataObj->request->path, -1) !== "/") {
                $dataObj->request->path = $dataObj->request->path . "/";
            }

            if ($dataObj->request->isLink) { //外部链接或文件相对路径+文件名
                //外部链接不用改 linkurl
                $tempObg->params["isLink"] = 1;
            } else {
                //非外部链接需要组合文件名
                $tempObg->params["isLink"] = 0;
                $tempObg->params["linkUrl"] = $dataObj->request->path . $dataObj->request->file;
            }
            if ($dataObj->request->color) {
                //外部链接不用改 linkurl
                $tempObg->params["style"] = "color:" . $dataObj->request->color . ";";
            }

            $checkResult = app("S_Admin_singlePage")->update($tempObg);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];  //吧响应结果数据赋值到最终数组 结果数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    //生成静态页
    function generateStaticPages($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                "id" => "",
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            foreach ($ids as $key => $val) {
                $tempObg = getParamsObj();
                $tempObg->params = array("id" => intval($val));
                $info = app("S_Admin_singlePage")->info($tempObg);
                if ($info["error_no"] != 0) {
                    $final_arr = $info;
                    break;
                } else {
                    $info = $info["result"];
                }

                if ($info["isLink"]) {
                    continue; //外部链接跳过
                }

                $template=$info["template"]?$info["template"]:"index/singlePage/detail";

                $data = array();
                $data["request"] = array("id" => $val);
                $response = view($template, $data);
                $html = $response->getcontent();  //静态源码
                $path = dirname($info['linkUrl']);
                if ($path){
                    $path = LTCMS_ROOT . "/public" . $path;
                }else{
                    $path = LTCMS_ROOT . "/public" ;
                }
                $fileName = basename($info['linkUrl']);
                $fileName=str_replace("{id}",$info['id'],$fileName); //替换变量
                makeDir($path);
                if (!file_put_contents($path."/".$fileName,$html)){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,"生成失败");
                }
            }
        }

        return $final_arr;
    }
}