<?php

namespace app\logic\admin;

class L_script_install
{
    /**
     * 执行脚本
     * @param string $paramObj
     */
    public function exec($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'method' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $execScript=LTCMS_ROOT."/version/ExecScript.php";
            if(is_file($execScript)){
                include_once $execScript;
                $class="ExecScript";
                if(class_exists($class)){
                    $obj=new $class();
                    $method=$dataObj->request->method;
                    if(method_exists($obj,"exec")){
                        $ok=$obj->exec($method);
                        if(!$ok){
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.execFail"));
                        }
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.methodNotExists",["method"=>"exec"]));
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.methodNotExists",["class"=>$class]));
                }
            }else{
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 执行安装脚本
     * @param string $paramObj
     */
    public function install($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $execScript=LTCMS_ROOT."/version/ExecScript.php";
            if(is_file($execScript)){
                include_once $execScript;
                $class="ExecScript";
                if(class_exists($class)){
                    $obj=new $class();
                    if(method_exists($obj,"install")){
                        $ok=$obj->install();
                        if(!$ok){
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.execFail"));
                        }
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.methodNotExists",["method"=>"exec"]));
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.methodNotExists",["class"=>$class]));
                }
            }else{
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        return $final_arr;
    }
}